package ru.yandex.crypta.graph2.model.matching.merge.algo.split;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.score.ComponentScoringStrategy;
import ru.yandex.crypta.graph2.model.matching.edge.EdgePriority;
import ru.yandex.crypta.graph2.model.matching.merge.algo.score.SimpleLinkScoringStrategy;
import ru.yandex.crypta.graph2.model.matching.merge.algo.split.inner.ComponentConnectivityInspector;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.weight.EdgeInfoProvider;

public class SplitByMinEdgeAlgorithm extends AbstractSplitAlgorithm {

    /**
     * How many edges we try to remove from components to split it.
     * Use as heuristic to tune performance.
     */
    private static final int SPLIT_REMOVAL_DEPTH = 5;

    private final EdgePriority edgePriority;

    public SplitByMinEdgeAlgorithm(ComponentScoringStrategy componentScoringStrategy,
            EdgeInfoProvider edgeInfoProvider)
    {
        super(componentScoringStrategy, new SimpleLinkScoringStrategy());
        this.edgePriority = new EdgePriority(edgeInfoProvider);

    }


    @Override
    public ListF<Edge> prepareRemovalCandidates(Component component) {
        SetF<Edge> removalCandidates = component.getInnerEdges().filter(
                e -> !edgePriority.getEdgeInfoProvider().isStrong(e)
        );

        ListF<Edge> fromWorstToBest = edgePriority.sortEdgesByActivityAsc(removalCandidates);
        // don't want to go too deep by performance reasons
        ListF<Edge> maybeOutdatedRemovalCandidates = fromWorstToBest.takeFiltered(
                e -> edgePriority.getEdgeInfoProvider().hasActivity(e),
                SPLIT_REMOVAL_DEPTH
        );
        ListF<Edge> otherRemovalCandidates = fromWorstToBest.takeFiltered(
                e -> !edgePriority.getEdgeInfoProvider().hasActivity(e),
                SPLIT_REMOVAL_DEPTH
        );
        return maybeOutdatedRemovalCandidates.plus(otherRemovalCandidates);
    }

    @Override
    public ListF<Edge> chooseRemovalEdges(Component component, ListF<Edge> removalCandidates) {
        ComponentConnectivityInspector connectivityInspector = new ComponentConnectivityInspector(component);
        connectivityInspector.findFirstSplit(removalCandidates);
        return connectivityInspector.getRemovedEdges();
    }


}
