package ru.yandex.crypta.graph2.model.matching.merge.algo.split.inner;

import java.util.Set;

import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DefaultListenableGraph;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.graph.JGraphTUtils;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;
import ru.yandex.crypta.graph2.model.soup.edge.MultiEdgeKey;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;

public class ComponentConnectivityInspector {
    private final DefaultListenableGraph<Vertex, Edge> graph;
    private final ConnectivityInspector<Vertex, Edge> cc;
    private final ListF<Edge> removedEdges = Cf.arrayList();

    public ComponentConnectivityInspector(Component component) {

        this.graph = new DefaultListenableGraph<>(JGraphTUtils.toGraph(component));
        this.cc = new ConnectivityInspector<>(this.graph);
        // make inspector aware of graph changes (e.g. edges removal)
        graph.addGraphListener(cc);
    }

    public static boolean isConnected(Component component) {
        ComponentConnectivityInspector cc = new ComponentConnectivityInspector(component);
        return cc.isSingleComponent();
    }

    private void removeEdge(Edge edge) {
        graph.removeEdge(edge);
        removedEdges.add(edge);
    }

    public ListF<Edge> getRemovedEdges() {
        return removedEdges;
    }

    private boolean hasSplit() {
        return !isSingleComponent();
    }

    public boolean isSingleComponent() {
        return cc.isGraphConnected();
    }

    public ListF<Component> findFirstSplit(ListF<Edge> removalCandidates) {

        for (Edge edgeToRemove : removalCandidates) {
            removeEdge(edgeToRemove);
            if (hasSplit()) {
                return splitToComponents();
            }
        }

        return Cf.list();
    }

    public ListF<Component> getSplit(ListF<Edge> removalCandidates) {

        for (Edge edgeToRemove : removalCandidates) {
            removeEdge(edgeToRemove);
        }
        if (cc.isGraphConnected()) {
            return Cf.list();
        }
        return splitToComponents();
    }

    public ListF<Component> splitToComponents() {

        if (cc.isGraphConnected()) {
            throw new IllegalStateException("The is not split, check isSingleComponent() first");
        }

        // fill vertices
        MapF<Set<Vertex>, Component> verticesGroupsToComponents = Cf.identityHashMap();

        for (Set<Vertex> connectedComponent : cc.connectedSets()) {
            SetF<Vertex> connectedComponentF = Cf.wrap(connectedComponent);
            verticesGroupsToComponents.put(connectedComponent, new Component(connectedComponentF));
        }

        // fill edges
        MapF<MultiEdgeKey, ListF<Edge>> edgesGrouped = Cf.wrap(graph.edgeSet())
                .groupBy(Edge::getMultiEdgeKey);

        for (MultiEdgeKey edgeKey : edgesGrouped.keySet()) {
            ListF<Edge> edges = edgesGrouped.getTs(edgeKey);
            Set<Vertex> v1Group = cc.connectedSetOf(edgeKey.getLeftVertex());
            Set<Vertex> v2Group = cc.connectedSetOf(edgeKey.getRightVertex());

            if (v1Group == v2Group) {
                Component componentOfVertex = verticesGroupsToComponents.getTs(v1Group);
                componentOfVertex.addInnerEdges(edges);
            }

        }

        return verticesGroupsToComponents.values().toList();

    }

}
