package ru.yandex.crypta.graph2.model.matching.merge.algo.split.inner;

import java.util.HashMap;
import java.util.Objects;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.crypta.graph2.model.matching.component.Component;
import ru.yandex.crypta.graph2.model.matching.component.ComponentCenter;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.graph.cryptaid.CryptaIdDispenser;
import ru.yandex.crypta.graph2.model.matching.merge.MergeOfferStatus;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;
import ru.yandex.crypta.graph2.model.soup.edge.Edge;

public class ComponentSplitDendrogram {

    private Component rightComponent;
    private Option<ComponentSplitDendrogram> leftSplit = Option.empty();

    private Component leftComponent;
    private Option<ComponentSplitDendrogram> rightSplit = Option.empty();

    private Component removedComponent;

    private ListF<Edge> edgesBetween;
    private MergeOfferStatus status;
    private MetricsTree scoreGain;

    String cryptaId;

    private ComponentSplitDendrogram() {
    }

    public ComponentSplitDendrogram(Component rightComponent, Component leftComponent, MetricsTree scoreGain, ListF<Edge> edgesBetween) {
        this.rightComponent = rightComponent;
        this.leftComponent = leftComponent;
        this.scoreGain = scoreGain;
        this.edgesBetween = edgesBetween;
        this.removedComponent = new Component();
    }

    public ComponentSplitDendrogram(Component rightComponent, Component leftComponent, Component removedComponent, MetricsTree scoreGain, ListF<Edge> edgesBetween) {
        this.rightComponent = rightComponent;
        this.leftComponent = leftComponent;
        this.scoreGain = scoreGain;
        this.edgesBetween = edgesBetween;
        this.removedComponent = removedComponent;
    }

    public Component getRemovedComponent() { return removedComponent; }

    public Component getRightComponent() {
        return rightComponent;
    }

    public Component getLeftComponent() {
        return leftComponent;
    }

    public ListF<Edge> getEdgesBetween() {
        return edgesBetween;
    }

    public MergeOfferStatus getStatus() {
        return status;
    }

    public void setCryptaId(String cryptaId) {
        this.cryptaId = cryptaId;
    }

    public String getCryptaId() {
        return cryptaId;
    }

    public void setScoreGain(MetricsTree scoreGain) {
        this.scoreGain = scoreGain;
    }

    public MetricsTree getScoreGain() {
        return scoreGain;
    }

    public ComponentSplitDendrogram withStatus(MergeOfferStatus status) {
        this.status = status;
        return this;
    }

    public ComponentSplitDendrogram withLeftSplit(Option<ComponentSplitDendrogram> leftSplit) {
        this.leftSplit = leftSplit;
        return this;
    }

    public ComponentSplitDendrogram withRightSplit(Option<ComponentSplitDendrogram> rightSplit) {
        this.rightSplit = rightSplit;
        return this;
    }

    public SetF<Component> allSplitComponents() {
        SetF<Component> result = Cf.hashSet();

        result.addAll(getChildSplit(rightComponent, rightSplit));
        result.addAll(getChildSplit(leftComponent, leftSplit));

        if (status.equals(MergeOfferStatus.SPLIT_BY_VERTEX)) {
            result.add(removedComponent);
        }

        return result;
    }

    private SetF<Component> getChildSplit(Component component, Option<ComponentSplitDendrogram> componentSplit) {

        // add only bottom level components that were not split
        if (componentSplit.isPresent() && componentSplit.get().status.equals(MergeOfferStatus.SPLIT)) {
            // recursion
            return componentSplit.get().allSplitComponents();
        } else {
            return Cf.set(component);
        }
    }

    public void setComponentCentersRecursively(CryptaIdDispenser cryptaIdDispenser, GraphInfo graphInfo, HashMap<String, ComponentCenter> componentCenters) {
        Option<ComponentCenter> leftComponentCenter = cryptaIdDispenser.getCryptaId(leftComponent, graphInfo);
        if (leftComponentCenter.isPresent()) {
            String leftCryptaId = leftComponentCenter.get().getCryptaId();
            leftComponent.setCryptaId(leftCryptaId);
            componentCenters.put(leftCryptaId, leftComponentCenter.get());
        }
        if (leftSplit.isPresent()) {
            leftSplit.get().setComponentCentersRecursively(cryptaIdDispenser, graphInfo, componentCenters);
            leftSplit.get().setCryptaId(leftComponent.getCryptaId());
        }

        Option<ComponentCenter> rightComponentCenter = cryptaIdDispenser.getCryptaId(rightComponent, graphInfo);
        if (rightComponentCenter.isPresent()) {
            String rightCryptaId = rightComponentCenter.get().getCryptaId();
            rightComponent.setCryptaId(rightCryptaId);
            componentCenters.put(rightCryptaId, rightComponentCenter.get());
        }
        if (rightSplit.isPresent()) {
            rightSplit.get().setComponentCentersRecursively(cryptaIdDispenser, graphInfo, componentCenters);
            rightSplit.get().setCryptaId(rightComponent.getCryptaId());
        }

    }

    public ListF<ComponentSplitDendrogram> flattenTree() {
        ListF<ComponentSplitDendrogram> result = Cf.arrayList(this);

        if (leftSplit.isPresent()) {
            result.addAll(leftSplit.get().flattenTree());
        }

        if (rightSplit.isPresent()) {
            result.addAll(rightSplit.get().flattenTree());
        }

        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ComponentSplitDendrogram that)) return false;
        return Objects.equals(rightComponent, that.rightComponent) &&
                Objects.equals(leftComponent, that.leftComponent);
    }

    @Override
    public int hashCode() {

        return Objects.hash(rightComponent, leftComponent);
    }
}
