package ru.yandex.crypta.graph2.model.matching.proto;

import java.util.Comparator;

import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeType;
import ru.yandex.crypta.graph2.model.soup.proto.Edge;
import ru.yandex.crypta.graph2.model.soup.proto.EdgeType;
import ru.yandex.crypta.graph2.model.soup.proto.EnumEdge;
import ru.yandex.crypta.graph2.model.soup.proto.MultiEdgeKey;

public class EdgeProtoHelper {

    public static final String DATES_COLUMN = "dates";

    public static final Comparator<CryptaIdEdgeMessage> EDGE_MESSAGE_COMPARATOR = Comparator
            .<CryptaIdEdgeMessage, String>comparing(CryptaIdEdgeMessage::getId1Type)
            .thenComparing(CryptaIdEdgeMessage::getId2)
            .thenComparing(CryptaIdEdgeMessage::getSourceType)
            .thenComparing(CryptaIdEdgeMessage::getLogSource)
            .thenComparing(CryptaIdEdgeMessage::getId1)
            .thenComparing(CryptaIdEdgeMessage::getId2);

    public static final Comparator<CryptaIdEdgeMessage> BY_WEIGHT_COMPARATOR = Comparator
            .comparingDouble(CryptaIdEdgeMessage::getSurvivalWeight)
            .thenComparingDouble(CryptaIdEdgeMessage::getDatesWeight)
            .thenComparing(EDGE_MESSAGE_COMPARATOR);

    public static final Comparator<CryptaIdEdgeMessage> BY_WEIGHT_DESC_COMPARATOR = BY_WEIGHT_COMPARATOR.reversed();

    public static EdgeType getEdgeType(CryptaIdEdgeMessage e) {
        return EdgeType.newBuilder()
                .setId1Type(e.getId1Type())
                .setId2Type(e.getId2Type())
                .setSourceType(e.getSourceType())
                .setLogSource(e.getLogSource())
                .build();
    }

    public static Edge toEdge(CryptaIdEdgeMessage message) {
        return Edge.newBuilder()
                .setId1(message.getId1())
                .setId1Type(message.getId1Type())
                .setId2(message.getId2())
                .setId2Type(message.getId2Type())
                .setSourceType(message.getSourceType())
                .setLogSource(message.getLogSource())
                .setDatesWeight(message.getDatesWeight())
                .setSurvivalWeight(message.getSurvivalWeight())
                .setIndevice(message.getIndevice())
                .build();
    }

    public static Edge toEdge(EdgeInComponent message) {
        return Edge.newBuilder()
                .setId1(message.getId1())
                .setId1Type(message.getId1Type())
                .setId2(message.getId2())
                .setId2Type(message.getId2Type())
                .setSourceType(message.getSourceType())
                .setLogSource(message.getLogSource())
                .setDatesWeight(message.getDatesWeight())
                .setSurvivalWeight(message.getSurvivalWeight())
                .setIndevice(message.getIndevice())
                .build();
    }

    public static EnumEdge toEnumEdge(EdgeInComponent edge) {
        return EnumEdge.newBuilder()
                .setId1(edge.getId1())
                .setId1Type(Soup.CONFIG.getIdType(edge.getId1Type()).getType())
                .setId2(edge.getId2())
                .setId2Type(Soup.CONFIG.getIdType(edge.getId2Type()).getType())
                .setSourceType(Soup.CONFIG.getSourceType(edge.getSourceType()).getType())
                .setLogSource(Soup.CONFIG.getLogSource(edge.getLogSource()).getType())
                .setDatesWeight(edge.getDatesWeight())
                .setSurvivalWeight(edge.getSurvivalWeight())
                .setIndevice(edge.getIndevice())
                .build();
    }

    public static MultiEdgeKey toMultiEdgeKey(CryptaIdEdgeMessage message) {
        return MultiEdgeKey.newBuilder()
                .setId1(message.getId1())
                .setId1Type(message.getId1Type())
                .setId2(message.getId2())
                .setId1Type(message.getId2Type())
                .build();
    }

    public static EdgeInComponent.Builder edgeInComponentBuilder(Edge edge) {
        return EdgeInComponent.newBuilder()
                .setId1(edge.getId1())
                .setId1Type(edge.getId1Type())
                .setId2(edge.getId2())
                .setId2Type(edge.getId2Type())
                .setSourceType(edge.getSourceType())
                .setLogSource(edge.getLogSource())
                .setDatesWeight(edge.getDatesWeight())
                .setSurvivalWeight(edge.getSurvivalWeight())
                .setIndevice(edge.getIndevice());
    }

    public static EdgeBetweenComponents.Builder edgeBetweenComponentsBuilder(Edge edge) {
        return EdgeBetweenComponents.newBuilder()
                .setId1(edge.getId1())
                .setId1Type(edge.getId1Type())
                .setId2(edge.getId2())
                .setId2Type(edge.getId2Type())
                .setSourceType(edge.getSourceType())
                .setLogSource(edge.getLogSource())
                .setDatesWeight(edge.getDatesWeight())
                .setSurvivalWeight(edge.getSurvivalWeight())
                .setIndevice(edge.getIndevice());
    }

    public static CryptaIdEdgeMessage.Builder reverse(CryptaIdEdgeMessage message) {
        boolean isReversed = message.getReversed();
        String reduceIdKey = isReversed ? message.getId2() : message.getId1();
        String reduceIdTypeKey = isReversed ? message.getId2Type() : message.getId1Type();
        return message.toBuilder()
                .setId(reduceIdKey)
                .setIdType(reduceIdTypeKey)
                .setReversed(!isReversed);
    }

    public static EdgeType edgeTypeFromConfig(TEdgeType edgeType) {
        return EdgeType.newBuilder()
                .setId1Type(Soup.CONFIG.name(edgeType.getId1Type()))
                .setId2Type(Soup.CONFIG.name(edgeType.getId2Type()))
                .setSourceType(Soup.CONFIG.name(edgeType.getSourceType()))
                .setLogSource(Soup.CONFIG.name(edgeType.getLogSource()))
                .build();
    }


}
