package ru.yandex.crypta.graph2.model.matching.vertex;

import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.soup.vertex.Vertex;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeFlattenField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;

/**
 * Represents additional info about relationship between vertex and the crypta component it belongs to
 */
@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class VertexInComponent {

    public static final String COMPONENT_WEIGHT_COLUMN = "componentWeight";

    @YTreeField
    @YTreeFlattenField
    private Vertex vertex;

    // just for schema
    @YTreeField
    @YTreeFlattenField
    @SuppressWarnings("UnusedVariable")
    private MergeKey mergeKey = MergeKey.EMPTY;

    @YTreeField
    private String cryptaId;

    public VertexInComponent(Vertex vertex, String cryptaId) {
        this.vertex = vertex;
        setCryptaId(cryptaId);
    }

    public VertexInComponent(String id, EIdType idType, String cryptaId) {
        this(new Vertex(id, idType), cryptaId);
    }

    public VertexInComponent(ru.yandex.crypta.graph2.model.matching.proto.VertexInComponent proto) {
        this(
                proto.getId(),
                Soup.CONFIG.getIdType(proto.getIdType()).getType(),
                proto.getCryptaId()
        );
        this.mergeKey = new MergeKey(proto.getMergeKey(), proto.getMergeKeyType());
    }

    public Vertex getVertex() {
        return vertex;
    }

    public String getCryptaId() {
        return cryptaId;
    }

    private void setCryptaId(String cryptaId) {
        this.cryptaId = cryptaId;
    }

    public static VertexInComponent fromVertex(Vertex vertex, String cryptaId) {
        return new VertexInComponent(vertex, cryptaId);
    }

    @Override
    public String toString() {
        return vertex.toString() + "[" + cryptaId + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VertexInComponent that)) {
            return false;
        }

        if (!vertex.equals(that.vertex)) {
            return false;
        }
        return cryptaId.equals(that.cryptaId);
    }

    @Override
    public int hashCode() {
        int result = vertex.hashCode();
        result = 31 * result + cryptaId.hashCode();
        return result;
    }


}
