import os
import yt.wrapper as yt

import crypta.graph.matching.publish.proto.config_pb2 as args_config

from crypta.graph.matching.publish.lib import Publisher, get_last_table, IdsStabilityChecker, YQLChecker, Metric
from library.python.protobuf.argparse import ArgumentParser


def main():
    parser = ArgumentParser(args_config.TMatchingPublishConfig, config_yaml_option="--MetricsYaml")
    args, conf = parser.parse_args()

    yt.config.set_proxy(conf.Yt.Proxy)

    vertices_no_multi_profile = yt.ypath_join(conf.Input, "vertices_no_multi_profile")
    generate_date = yt.get_attribute(vertices_no_multi_profile, "generate_date")

    if not conf.Metrics:
        conf.SkipChecks = True

    if conf.SkipChecks:
        checks = []
    else:
        stability_check = IdsStabilityChecker(
            metrics=[
                Metric(m.Kind, m.Field, m.Series, m.Threshold)
                for m in conf.Metrics
            ],
            checking_table=vertices_no_multi_profile,
            generate_date=generate_date,
            last_valid_table=get_last_table(conf.HistoryDir)
        )

        yql_checker = YQLChecker(
            generate_date,
            metrics=[stability_check],
            yt_proxy=conf.Yt.Proxy,
            yt_pool=conf.Yt.Pool or os.getenv("YT_POOL"),
            upload_metrics=conf.Upload
        )

        checks = [yql_checker]

    p = Publisher(conf.Input, conf.Output, checks=checks, skip_checks=conf.SkipChecks)
    p.run()


if __name__ == "__main__":
    main()
