{% include '/templates/yql/adaptors/matching_%s.sql.j2' % version %}
{% include '/templates/yql/stable/make_diff.sql.j2' %}

-- ========================================================================= --

DO $make_diff('{{ stable.old }}', '{{ stable.period }}');

COMMIT;

SELECT
    '{{ version }}' AS version,
    DateTime::ToSeconds(DateTime('{{ date }}T12:00:00Z')) AS ts,
    '{{ date }}' AS dt,
    kind,
    field,
    CAST(absolute AS double) AS absolute,
    CAST(denominator AS double) AS denominator,
    IF(denominator != 0, 1.0 * absolute / denominator) AS ratio,
    IF(denominator != 0, 100.0 * absolute / denominator) AS percentage
FROM @metrics
WHERE kind == '{{ stable.kind }}' AND field IN ('{{ stable.fields | join("', '") | safe }}')
ORDER BY version, ts, dt, kind, field
INTO RESULT `metrics`;
