-- =========================================================================

$date = '{{ date }}';
$ts_date = SELECT DateTime::ToSeconds(Date('{{ date }}'));
$fp_dir = '//home/crypta/production/state/fingerprint/appmetrica';
$all_pairs = $fp_dir || '/all_pairs';
$mobile_ip = 'mobile_ip';
$mobile = 'mobile';
$location = 'location';
$identity = 'identity';


-- =========================================================================

DEFINE SUBQUERY $count_stats($get_table, $key, $source, $span, $cnt_type, $real_cnt, $total_real_cnt) AS
    DEFINE SUBQUERY $_count_stats($with_idfa) AS
        $total_real_cnt = IF($source == $mobile_ip, $real_cnt, $total_real_cnt);
        $_real_cnt = IF($with_idfa, $real_cnt, NULL);
        $_total_real_cnt = IF($with_idfa, $total_real_cnt, NULL);
        $with_idfa_field = IF($with_idfa, "with", "without");
        SELECT
            $source AS source,
            $key AS key,
            $span AS span,
            $cnt_type AS cnt_type,
            $date AS fielddate,
            $with_idfa_field AS with_idfa,

            $_total_real_cnt AS total,
            $frac($_real_cnt, $_total_real_cnt) AS data_rate,
            $frac(COUNT(*), $_total_real_cnt) AS total_recall,

            COUNT(*) AS fp,
            $_real_cnt AS real,
            COUNT_IF(trueIdfa) AS true_idfa,
            $frac(COUNT_IF(trueIdfa), COUNT(*)) AS precision,
            0. AS total_precision,
            $frac(COUNT_IF(trueIdfa), $_real_cnt) AS recall,
            0. AS coverage,
            0. AS total_coverage,

            COUNT_IF(withCryptaID) AS with_cid,
            COUNT_IF(trueCryptaID) AS true_cid,
            $frac(COUNT_IF(trueCryptaID), COUNT_IF(withCryptaID)) AS cid_rate,
        FROM $get_table() WHERE withIdfa == $with_idfa
    END DEFINE;

    SELECT * FROM $_count_stats(true)
    UNION ALL
    SELECT * FROM $_count_stats(false);
END DEFINE;

DEFINE SUBQUERY $count_pairs_stats($get_table, $key, $source, $span, $real_cnt, $total_real_cnt) AS
    SELECT * FROM $count_stats($get_table, $key, $source, $span, "pairs", $real_cnt, $total_real_cnt);
END DEFINE;

DEFINE SUBQUERY $count_ids_coverage_stats($get_pairs_table, $key, $source, $span, $real_cnt, $total_real_cnt) AS
    $pairs = SELECT * FROM $get_pairs_table();

    $ids_cov =
        SELECT
            id, id_type,
            MAX(withIdfa) AS withIdfa,
            MAX(trueIdfa) AS trueIdfa,
            MAX(withCryptaID) AS withCryptaID,
            MAX(trueCryptaID) AS trueCryptaID,
        FROM (
            SELECT
                id1 AS id,
                id1Type AS id_type,
                withIdfa, trueIdfa,
                withCryptaID, trueCryptaID
            FROM $pairs
            UNION ALL
            SELECT
                id2 AS id,
                id2Type AS id_type,
                withIdfa, trueIdfa,
                withCryptaID, trueCryptaID
            FROM $pairs
        )
        GROUP BY (id, id_type)
    ;
    DEFINE SUBQUERY $get_table() AS SELECT * FROM $ids_cov; END DEFINE;
    SELECT * FROM $count_stats($get_table, $key, $source, $span, "ids", $real_cnt, $total_real_cnt);
END DEFINE;

DEFINE SUBQUERY $count_pairs_and_ids_stats_($get_pairs, $key, $source, $span, $real_pairs_cnt, $real_ids_cnt, $total_real_pairs_cnt, $total_real_ids_cnt) AS
    DEFINE SUBQUERY $get_pairs_without_args() AS SELECT * FROM $get_pairs($all_pairs); END DEFINE;

    SELECT * FROM $count_pairs_stats($get_pairs_without_args, $key, $source, $span, $real_pairs_cnt, $total_real_pairs_cnt)
    UNION ALL
    SELECT * FROM $count_ids_coverage_stats($get_pairs_without_args, $key, $source, $span, $real_ids_cnt, $total_real_ids_cnt)
END DEFINE;

DEFINE SUBQUERY $count_pairs_and_ids_stats($get_pairs, $key, $source, $span) AS
    SELECT * FROM $count_pairs_and_ids_stats_($get_pairs, $key, $source, $span, 0., 0., 0., 0.);
END DEFINE;

DEFINE SUBQUERY $count_idfa_stats($get_ids) AS
    $ids_with_idfa = SELECT * FROM $get_ids() WHERE idfa IS NOT NULL AND idfa != "00000000-0000-0000-0000-000000000000";

    $ids_cnt_by_idfa =
        SELECT
            idfa,
            COUNT(*) AS cnt
        FROM (
            SELECT
                id,
                MAX(idfa) AS idfa,
            FROM $ids_with_idfa
            GROUP BY (id)
        )
        GROUP BY (idfa) HAVING COUNT(id) > 1
    ;

    $pairs_cnt_by_idfa =
        SELECT
            SUM(cnt * (cnt-1) / 2)
        FROM $ids_cnt_by_idfa
    ;

    $ids_cnt_by_idfa =
        SELECT
            SUM(cnt)
        FROM $ids_cnt_by_idfa
    ;

    SELECT
        $pairs_cnt_by_idfa AS pairs_cnt_by_idfa,
        $ids_cnt_by_idfa AS ids_cnt_by_idfa,
END DEFINE;

DEFINE SUBQUERY $count_daily_stats($source, $total_real_pairs_cnt, $total_real_ids_cnt) AS
    $dir = $fp_dir || "/" || $source;
    $pairs = $dir || '/pairs/' || $date;
    $ids = $dir || '/ids/' || $date;

    DEFINE SUBQUERY $get_pairs($all_pairs) AS SELECT * FROM $pairs; END DEFINE;
    DEFINE SUBQUERY $get_ids() AS SELECT * FROM $ids; END DEFINE;

    $idfa_stats = SELECT * FROM $count_idfa_stats($get_ids);
    $ids_cnt_by_idfa = SELECT ids_cnt_by_idfa FROM $idfa_stats;
    $pairs_cnt_by_idfa = SELECT pairs_cnt_by_idfa FROM $idfa_stats;

    SELECT * FROM $count_pairs_and_ids_stats_($get_pairs, "total", $source, "daily", $pairs_cnt_by_idfa, $ids_cnt_by_idfa,
      $total_real_pairs_cnt, $total_real_ids_cnt
    );
END DEFINE ;


$mobile_ip_metrics =
    SELECT * FROM $count_daily_stats($mobile_ip, NULL, NULL);
;

$total_real_daily_pairs_cnt =
    SELECT real FROM $mobile_ip_metrics
    WHERE with_idfa == "with" AND cnt_type == "pairs"
;

$total_real_daily_ids_cnt =
    SELECT real FROM $mobile_ip_metrics
    WHERE with_idfa == "with" AND cnt_type == "ids"
;

$app_metrics =
    SELECT * FROM $mobile_ip_metrics
    UNION ALL
    SELECT * FROM $count_daily_stats($identity, $total_real_daily_pairs_cnt, $total_real_daily_ids_cnt)
    UNION ALL
    SELECT * FROM $count_daily_stats($location, $total_real_daily_pairs_cnt, $total_real_daily_ids_cnt)
    UNION ALL
    SELECT * FROM $count_daily_stats($mobile, $total_real_daily_pairs_cnt, $total_real_daily_ids_cnt)
    UNION ALL

    SELECT * FROM $count_pairs_and_ids_stats($get_total_pairs, "total", "app", "total")
    UNION ALL
    SELECT * FROM $count_pairs_and_ids_stats($get_soup_pairs, "soup", "app", "total")
    UNION ALL
    SELECT * FROM $count_pairs_and_ids_stats($get_new_pairs, "total", "app", "new")
    UNION ALL
    SELECT * FROM $count_pairs_and_ids_stats($get_soup_new_pairs, "soup", "app", "new")
;
