$date = '{{ date }}';
$ts_date = SELECT DateTime::ToSeconds(Date('{{ date }}'));

$frac = ($value1, $value2) -> {
    $result = 1. * ($value1 ?? 0.) / ($value2 ?? 0.);
    RETURN IF(Math::IsFinite($result), $result, 0.);
};

$soup_filter = ($row)->($row.isGood);

DEFINE SUBQUERY  $get_total_pairs($all_pairs) AS
    SELECT * FROM $all_pairs WHERE firstTimestamp <= $ts_date;
END DEFINE;

DEFINE SUBQUERY  $get_soup_pairs($all_pairs) AS
    SELECT * FROM $all_pairs WHERE $soup_filter(TableRow()) AND firstTimestamp <= $ts_date;
END DEFINE;

DEFINE SUBQUERY  $get_new_pairs($all_pairs) AS
    SELECT * FROM $all_pairs WHERE firstTimestamp == $ts_date;
END DEFINE;

DEFINE SUBQUERY  $get_soup_new_pairs($all_pairs) AS
    SELECT * FROM $all_pairs WHERE $soup_filter(TableRow()) AND firstTimestamp == $ts_date
END DEFINE;



{% include 'app_query.sql.j2' %}
{% include 'rtb_query.sql.j2' %}
{% include 'ssp_query.sql.j2' %}


SELECT * FROM $app_metrics
UNION ALL
SELECT * FROM $rtb_metrics
UNION ALL
SELECT * FROM $ssp_metrics
