$composition  = '//home/crypta/production/state/households_new/output/composition';
$export_edges = '//home/crypta/production/state/households_new/output/edges';
$bb_tskv_tbl  = '//home/crypta/production/state/households_new/bb_output/households_to_bb';
-- ========================================================================== --
$date = '{{ date }}';

$HH_ONE_YUID = 'one yuid';
$HH_OK = 'ok';
$HH_MONSTER = 'monster';
$HH_MONSTER_PLUS = 'super monster';

$LIMIT_MONSTER = 1000;
$LIMIT_MONSTER_PLUS = 10000;
-- ========================================================================== --

$size_to_range = ($size) -> {
    RETURN CASE
        WHEN $size <= 1 THEN $HH_ONE_YUID
        WHEN $size < $LIMIT_MONSTER THEN $HH_OK
        WHEN $size < $LIMIT_MONSTER_PLUS THEN $HH_MONSTER
        ELSE $HH_MONSTER_PLUS
    END;
};

$hh_ok_predicat = ($size, $socdems) -> {
    RETURN $size > 1 AND $size < $LIMIT_MONSTER;
};

$hh_ok_socdem_predicat = ($size, $socdems) -> {
    RETURN ($size > 1 AND $size < $LIMIT_MONSTER) AND $socdems > 0;
};

$hh_ok_predicat_any_crypta_id = ($size, $socdems, $crypta_ids_c) -> {
    RETURN ($size > 1) AND ($size < $LIMIT_MONSTER);
};

$hh_ok_predicat_no_one_crypta_id = ($size, $socdems, $crypta_ids_c) -> {
    RETURN ($size > 1) AND ($size < $LIMIT_MONSTER) AND ($crypta_ids_c > 1);
};
-- ========================================================================== --

DEFINE SUBQUERY $hh_size_by_yuid($title) AS
    SELECT ($title || key) AS key, COUNT(1) AS hh_size_by_yuids
    FROM $composition
    GROUP BY $size_to_range(size) AS key;
END DEFINE;

DEFINE SUBQUERY $hh_size_by_crypta_id($title, $predicat) AS
    SELECT
        ($title || key) AS key,
        COUNT(1) AS hh_size_by_crypta_id
    FROM $composition
    WHERE $predicat(size, socdems)
    GROUP BY CAST(Yson::GetLength(Yson::Lookup(data, 'crypta_ids')) AS String) AS key;
END DEFINE;

DEFINE SUBQUERY $hh_by_socdems($title, $predicat) AS
    $hh_socdem = (
        SELECT
            hhid,
            size,
            IF((Yson::LookupInt64(info, 'female') != 0), 'female', Null) AS has_female,
            IF((Yson::LookupInt64(info, 'male') != 0), 'male', Null) AS has_male,
            IF((Yson::LookupInt64(info, 'grand') != 0), 'grand', Null) AS has_old,
            IF((Yson::LookupInt64(info, 'child') != 0), 'child', Null) AS has_child
        FROM $composition
        WHERE $predicat(size, socdems)
    );

    SELECT ($title || groups) AS key, hh_c AS hh_socdem_count
    FROM (
        SELECT groups, SUM(size) AS hh_c
        FROM $hh_socdem
        GROUP BY String::JoinFromList(
            ListSort(AsList(has_female, has_male, has_old, has_child)),
            '_') AS groups
    ) WHERE groups != "";
END DEFINE;

DEFINE SUBQUERY $hh_by_mp_socdem($title, $predicat) AS
    SELECT ($title || IF(has_mp_socdem, '+', '-')) AS key, hh_c AS hh_mp_with_socdem
    FROM (
        SELECT has_mp_socdem, COUNT(1) AS hh_c
        FROM $composition
        WHERE $predicat(size, socdems, Yson::GetLength(Yson::Lookup(data, 'crypta_ids')))
        GROUP BY (
            Yson::GetLength(Yson::Lookup(data, 'mp_age')) +
            Yson::GetLength(Yson::Lookup(data, 'mp_sex'))
        ) > 0 AS has_mp_socdem
    );
END DEFINE;

DEFINE SUBQUERY $hh_any_socdem($title, $predicat) AS
    $hh_socdem = (
        SELECT
            hhid,
            size,
            IF(
                (Yson::GetLength(Yson::Lookup(data, 'sex')) != 0)
                /*OR (Yson::GetLength(Yson::Lookup(data, 'mp_sex')) != 0)*/, 'sex', Null) AS has_sex,
            IF(
                (Yson::GetLength(Yson::Lookup(data, 'age')) != 0)
                /*OR (Yson::GetLength(Yson::Lookup(data, 'mp_age')) != 0)*/, 'age', Null) AS has_age
        FROM $composition
        WHERE $predicat(size, socdems, Yson::GetLength(Yson::Lookup(data, 'crypta_ids')))
    );

    SELECT ($title || IF(groups != "", groups, "no_socdem")) AS key, hh_c AS hh_any_socdem
    FROM (
        SELECT groups, SUM(size) AS hh_c
        FROM $hh_socdem
        GROUP BY String::JoinFromList(
            ListSort(AsList(has_sex, has_age)),
            '_') AS groups
    );
END DEFINE;

$hh_smart_tv_edges = (
    SELECT "smart_tv_edges" AS key, COUNT(1) AS hh_edges
    FROM $export_edges
);

$hh_bb_output = (
    SELECT "bb_output_yuids" AS key, COUNT(1) AS hh_bb_output
    FROM $bb_tskv_tbl
);

SELECT
    $date AS fielddate, key,
    hh_size_by_yuids     ?? 0 AS hh_size_by_yuids,
    hh_size_by_crypta_id ?? 0 AS hh_size_by_crypta_id,
    hh_socdem_count      ?? 0 AS hh_socdem_count,
    hh_mp_with_socdem    ?? 0 AS hh_mp_with_socdem,
    hh_any_socdem        ?? 0 AS hh_any_socdem,
    hh_edges             ?? 0 AS hh_edges,
    hh_bb_output         ?? 0 AS hh_bb_output
FROM (
    SELECT * FROM $hh_size_by_yuid("hh_size_by_yuid-")
    UNION ALL
    SELECT * FROM $hh_size_by_crypta_id("hh_size_by_crypta_id-", $hh_ok_socdem_predicat)
    UNION ALL
    SELECT * FROM $hh_by_socdems("hh_ok_by_socdems-", $hh_ok_predicat)
    UNION ALL
    SELECT * FROM $hh_by_mp_socdem("hh_ok_by_mp_socdem-", $hh_ok_predicat_any_crypta_id)
    UNION ALL
    SELECT * FROM $hh_any_socdem("hh_ok_by_any_socdem-", $hh_ok_predicat_any_crypta_id)
    UNION ALL
    SELECT * FROM $hh_by_mp_socdem("hh_ok_no_one_ccid_by_mp_socdem-", $hh_ok_predicat_no_one_crypta_id)
    UNION ALL
    SELECT * FROM $hh_any_socdem("hh_ok_no_one_ccid_by_any_socdem-", $hh_ok_predicat_no_one_crypta_id)
    UNION ALL
    SELECT * FROM $hh_smart_tv_edges
    UNION ALL
    SELECT * FROM $hh_bb_output
);
