-- =========================================================================

$date = '{{ date }}';

$vertices = '//home/crypta/production/state/graph/v2/matching/vertices_no_multi_profile_by_id_type';
$vertices_properties = '//home/crypta/production/state/graph/v2/matching/vertices_properties_by_crypta_id';

-- =========================================================================

$cryptaId_login = (
    FROM $vertices
    SELECT
        cryptaId,
        COUNT(DISTINCT id) as count_logins
    WHERE id_type == "login"
        AND id NOT LIKE "phne-%"
    GROUP BY cryptaId
);

$cryptaId_country = (
    FROM $vertices_properties
    SELECT
        cryptaId,
        Geo::RoundRegionById(CAST(
                Mode(main_region_country)[0].Value AS Int32
            ), "country"
        ).name AS country
    GROUP BY cryptaId
);

$cryptaId_devices= (
    SELECT
        cryptaId,
        COUNT(DISTINCT dev_pair) AS count_devices
    FROM (
        SELECT
            cryptaId,
            AsTuple(id_type, id) AS dev_pair
        FROM $vertices_properties
        WHERE id_type IN ("gaid", "idfa", "oaid")
            AND dates IS NOT NULL
            AND Yson::GetLength(dates) > 1
    ) GROUP BY cryptaId
);

$cryptaId_mobile = (
    FROM $vertices_properties
    SELECT
        cryptaId,
        COUNT(DISTINCT ua_profile) as count_mobiles
    WHERE ua_profile LIKE "m|%"
        AND dates IS NOT NULL
        AND Yson::GetLength(dates) > 1
    GROUP BY cryptaId
);

$cryptaId_desktop = (
    FROM $vertices_properties
    SELECT
        cryptaId,
        COUNT(DISTINCT ua_profile) as count_desktop
    WHERE ua_profile LIKE "d|%"
        AND dates IS NOT NULL
        AND Yson::GetLength(dates) > 1
    GROUP BY cryptaId
);

-- =========================================================================

$all_joined = (
    SELECT
        cryptaId,
        SOME(count_logins) AS count_logins,
        SOME(count_devices) AS count_devices,
        SOME(count_mobiles) AS count_mobiles,
        SOME(count_desktop) AS count_desktop
    FROM (
        SELECT * FROM $cryptaId_login
        UNION ALL SELECT * FROM $cryptaId_devices
        UNION ALL SELECT * FROM $cryptaId_mobile
        UNION ALL SELECT * FROM $cryptaId_desktop
    ) GROUP BY cryptaId
);

$all_joined_wih_country = (
    SELECT
        COALESCE(country_table.country, "None") AS country,
        properties.count_logins AS count_logins,
        properties.count_devices AS count_devices,
        properties.count_mobiles AS count_mobiles,
        properties.count_desktop AS count_desktop
    FROM $all_joined AS properties
    LEFT JOIN $cryptaId_country AS country_table
    USING (cryptaId)
);

-- =========================================================================

FROM $all_joined_wih_country
SELECT
    $date AS fielddate,
    country,
    COALESCE(SUM(count_logins), 0) AS sum_logins,
    COALESCE(SUM_IF(count_devices, count_logins > 0), 0) AS sum_devices_with_login,
    COALESCE(1.0 * SUM_IF(count_devices, count_logins > 0) / SUM(count_devices), 0) AS ratio_devices_with_login,
    COALESCE(SUM_IF(count_logins, count_devices > 0), 0) AS sum_login_with_devices,
    COALESCE(1.0 * SUM_IF(count_logins, count_devices > 0) / SUM(count_logins), 0) AS ratio_login_with_devices,
    COALESCE(SUM_IF(count_mobiles, count_logins > 0), 0) AS sum_mobile_with_login,
    COALESCE(1.0 * SUM_IF(count_mobiles, count_logins > 0) / SUM(count_mobiles), 0) AS ratio_mobile_with_login,
    COALESCE(SUM_IF(count_logins, count_mobiles > 0), 0) AS sum_login_with_mobiles,
    COALESCE(1.0 * SUM_IF(count_logins, count_mobiles > 0) / SUM(count_logins), 0) AS ratio_login_with_mobile,
    COALESCE(SUM_IF(count_desktop, count_logins > 0), 0) AS sum_desktop_with_login,
    COALESCE(1.0 * SUM_IF(count_desktop, count_logins > 0) / SUM(count_desktop), 0) AS ratio_desktop_with_login,
    COALESCE(SUM_IF(count_logins, count_desktop > 0), 0) AS sum_login_with_desktop,
    COALESCE(1.0 * SUM_IF(count_logins, count_desktop > 0) / SUM(count_logins), 0) AS ratio_login_with_desktop
GROUP BY country

-- =========================================================================
