{% set only_fresh = True %}
-- ========================================================================= --
$date = '{{ date }}';

$shift_date = ($dt, $days) -> {
    $date = DateTime::MakeDatetime(DateTime::Parse("%Y-%m-%d")($dt));
    $delta = DateTime::IntervalFromDays($days);
    $str_date = DateTime::Format("%Y-%m-%d")($date + $delta);
    RETURN Unwrap($str_date);
};

$limit_date = $shift_date($date, -14);
$limit_date_future = $shift_date($date, +14);

$table_name = Re2::Capture(@@^.*\/(?P<name>[^\/]+)$@@);

$get_edge = ($id1, $id2, $source, $log) -> {
    RETURN String::JoinFromList([$id1, $id2, $source, $log], "_");
};

{% set WITH_SCHEMA = """
    -- Bad table schema `yandexuid--distr_* (yasoft)`
    WITH SCHEMA Struct<
        `id1`: String?,
        `id1Type`: String?,
        `id2`: String?,
        `id2Type`: String?,
        `sourceType`: String?,
        `logSource`: String?,
        -- may be dates list, or single date string
        `dates`: List<String>?,
        `date`: String?
    >
""" %}

$tables = (
    SELECT
        'table' AS kind,
        $table_name(`Path`).name AS key,
        Yson::LookupUint64(Attributes, 'row_count') AS records
    FROM FOLDER(`//home/crypta/production/state/graph/v2/soup`, 'dynamic;row_count')
    WHERE Type = 'table' AND Yson::LookupBool(Attributes, 'dynamic') = false
);

$cooked_tables = (
    SELECT
        'cooked_soup' AS kind,
        $table_name(`Path`).name AS key,
        Yson::LookupUint64(Attributes, 'row_count') AS records
    FROM FOLDER(`//home/crypta/production/state/graph/v2/soup/cooked`, 'dynamic;row_count')
    WHERE Type = 'table' AND Yson::LookupBool(Attributes, 'dynamic') = false
);

$ids = (
    SELECT
        'id_type' AS kind,
        id_type AS key,
        COUNT(1) AS records
    FROM (
        SELECT id1Type AS id_type, id1 AS id
        FROM `//home/crypta/production/state/graph/v2/soup/cooked/soup_edges`
        UNION ALL
        SELECT id2Type AS id_type, id2 AS id
        FROM `//home/crypta/production/state/graph/v2/soup/cooked/soup_edges`
    ) GROUP BY id_type
);

$stream_day = '//home/crypta/production/state/graph/stream/soup/day/' || $date || '/validation';
$soup_day = '//home/crypta/production/state/graph/v2/soup/day/' || $date || '/validation';

$soup_validation = (
    SELECT $date AS dt, $get_edge(id1Type, id2Type, sourceType, logSource) AS edge
    FROM (
        SELECT * FROM LIKE($stream_day, '%') {{ WITH_SCHEMA }}
        UNION ALL SELECT * FROM LIKE($soup_day, '%') {{ WITH_SCHEMA }}
    )
);

$soup_daily_activity = (
    SELECT
        edge, dt, is_one_day
    FROM (
        SELECT
            TableName() AS edge,
            dates ?? ListCreate(String) AS dates,
            (ListLength(dates ?? ListCreate(String)) == 1) AS is_one_day,
        FROM LIKE(
            `//home/crypta/production/state/graph/v2/soup`,
            '%_%_%_%'
        ) WITH SCHEMA Struct<
            dates: List<String>?
        >
    ) FLATTEN LIST BY dates AS dt
    {% if only_fresh %} WHERE
        (dt > $limit_date)
        AND (dt < $limit_date_future){% endif %}
);

$hard_soup_stat = (
    SELECT
        dt,
        'daily' AS kind,
        edge AS key,
        COUNT(1) AS records,
        COUNT_IF(is_one_day) AS records_one_day,
        COUNT_IF(NOT is_one_day) AS records_multi_day,
    FROM $soup_daily_activity
    GROUP BY edge, dt
);

$validation_stat = (
    SELECT
        dt,
        'invalid' AS kind,
        edge AS key,
        COUNT(1) AS records
    FROM $soup_validation
    GROUP BY edge, dt
);

-- ========================================================================= --

SELECT
    dt ?? $date AS fielddate,
    kind,
    key,
    records
FROM (
    SELECT * FROM $tables
    UNION ALL
    SELECT * FROM $cooked_tables
    UNION ALL
    SELECT * FROM $ids
    UNION ALL
    SELECT dt, kind, key, records FROM $hard_soup_stat
    UNION ALL
    SELECT dt, kind || '_one_day' AS kind, key, records_one_day AS records FROM $hard_soup_stat
    UNION ALL
    SELECT dt, kind || '_multi_day' AS kind, key, records_multi_day AS records FROM $hard_soup_stat
    UNION ALL
    SELECT dt, kind, key, records FROM $validation_stat
);
