$export_data = '{{ source }}';

DEFINE SUBQUERY $convert_raw_to_column_format($dir) AS
    SELECT
    CAST(cryptaId AS String) as cryptaId,
    Identifiers::FromStruct(vertex).IdTypeString AS id_type,
    Identifiers::FromStruct(vertex).Value AS id,
    FROM (
        SELECT
            tbl.*,
            RTSklejkaUdf::DecodeMichurinState(State, Codec).Graph.Id AS cryptaId,
            RTSklejkaUdf::DecodeMichurinState(State, Codec).Graph.Vertices AS vertices
        FROM $dir AS tbl
    ) flatten list by vertices AS vertex
END DEFINE;

$crypta_source_data = SELECT * FROM $convert_raw_to_column_format($export_data);

$parse_edge = ($edge, $vertices) -> {

    $id1 = $vertices[$edge.Node1 ?? 0];
    $id2 = $vertices[$edge.Node2 ?? 0];

    $edge_dict = ToDict(ListMap($edge.Attributes, ($kv) -> {
        return AsTuple($kv.Name, $kv.Value);
    }));

    $source_type = $edge_dict['source_type'];
    $log_source = $edge_dict['log_source'];
    $spanning = $edge_dict['spanning'];

    return AsStruct(
        $id1.Id as id1,
        $id1.Type as id1Type,
        $id2.Id as id2,
        $id2.Type as id2Type,
        $source_type as sourceType,
        $log_source as logSource,
        $spanning as spanning
    );

};

$graphs = (
SELECT
    cryptaId,
    Unwrap(graph).Nodes as vertices,
    Unwrap(graph).Edges as edges
FROM $export_data
);

$edges = (
select
    $parse_edge(edge, vertices) as edge,
    cryptaId
from $graphs
flatten list by edges as edge
);

$edges_by_cryptaid = (
select
    cryptaId,
    edge.id1Type as id1Type,
    edge.id2Type as id2Type,
    edge.sourceType as sourceType,
    edge.logSource as logSource,
    edge.id1 as id1,
    edge.id2 as id2,
    ListCreate(String) as dates,
    1 as datesWeight,
    null as indevice,
    null as merge_key,
    null as merge_key_type,
    1 as survivalWeight
from $edges
);

$crypta_edges_v2 = (
    SELECT
        cryptaId AS crypta_id,
        id,
        id_type
    FROM $crypta_source_data
);

$crypta_size_v2 = (
    SELECT
        crypta_id,
        COUNT(1) AS crypta_id_size
    FROM (
        SELECT * FROM $crypta_edges_v2
        WHERE id_type == 'yandexuid'
    )
    GROUP BY crypta_id
);

DEFINE SUBQUERY $CRYPTA_RAW() AS
    SELECT
        yandexuid_crypta.crypta_id AS crypta_id,
        yandexuid_crypta.yandexuid AS yandexuid,
        crypta_size.crypta_id_size AS crypta_id_size
    FROM (
        SELECT
            CAST(id AS Uint64) AS yandexuid,
            crypta_id
        FROM $crypta_edges_v2 WHERE id_type == 'yandexuid'
    ) AS yandexuid_crypta
    INNER JOIN $crypta_size_v2 AS crypta_size
    USING (crypta_id);
END DEFINE;
