$crypta_source_data = '{{ source }}';
$properties = '//home/crypta/production/state/graph/{{ version }}/matching/vertices_properties_by_crypta_id';
$staff_output = '//home/crypta/production/state/graph/{{ version }}/matching/staff';


DEFINE SUBQUERY $convert_raw_to_column_format ($dir) AS
    SELECT
        id,
        id_type,
        cryptaId
    FROM $dir
END DEFINE;

$edges_by_cryptaid = (
    SELECT * FROM `//home/crypta/production/state/graph/{{ version }}/matching/edges_by_crypta_id`
    WITH COLUMNS Struct<dates: List<String>?>
);

$crypta_edges_v2 = (
    SELECT
        cryptaId AS crypta_id,
        id,
        id_type
    FROM $crypta_source_data
);

$crypta_size_v2 = (
    SELECT
        crypta_id,
        COUNT(1) AS crypta_id_size
    FROM (
        SELECT * FROM $crypta_edges_v2
        WHERE id_type == 'yandexuid'
    )
    GROUP BY crypta_id
);

DEFINE SUBQUERY $CRYPTA_RAW() AS
    SELECT
        yandexuid_crypta.crypta_id AS crypta_id,
        yandexuid_crypta.yandexuid AS yandexuid,
        crypta_size.crypta_id_size AS crypta_id_size
    FROM (
        SELECT
            CAST(id AS Uint64) AS yandexuid,
            crypta_id
        FROM $crypta_edges_v2 WHERE id_type == 'yandexuid'
    ) AS yandexuid_crypta
    INNER JOIN $crypta_size_v2 AS crypta_size
    USING (crypta_id);
END DEFINE;
