{% include '/templates/yql/ads/qualifiers_identification.sql.j2' %}


$user_id_type = ($t) -> {
    RETURN CASE
            WHEN $t = 6 THEN 'puid'
            WHEN $t = 7 THEN 'uuid'
            WHEN $t = 8 THEN 'gaid'
            WHEN $t = 9 THEN 'idfa'
            WHEN $t = 19 THEN 'ifv'
            WHEN $t = 10 THEN 'mm_device_id'
            WHEN $t = 15 THEN 'oaid'
            WHEN $t = 13 THEN 'duid'
    ELSE 'y'
        END;
};


$beh_hit_log =
    SELECT
        $make_trafficQualifier(Options, SSPID, ImpressionOptions) AS trafficQualifier,
        $make_deviceQualifier(DetailedDeviceType, ImpressionOptions) AS deviceQualifier,
        ListMap(
            Bigb::ParseProfile(ProfileDump).source_uniqs ?? AsList(),
            ($uniq) -> ($user_id_type($uniq.id_type))
        ) AS source_uniqs,
        ListMap(
            Bigb::ParseProfile(ProfileDump).glued_uniqs ?? AsList(),
            ($uniq) -> ($user_id_type($uniq.id_type))
        ) AS glued_uniqs,
    FROM
        `//home/bs/logs/JoinedEFHProfileHitLog/Shows/1h/{{date}}T13:00:00`
    WHERE
        FraudBits = 0;


$filter = ($glued, $key) -> {
    RETURN ListLength(ListFilter($glued, ($id_type) -> ($id_type == $key)));
};



$sample =
    SELECT
        '{{ prefix }}' AS kind,
        '{{ prefix }}_x_' || trafficQualifier || '_' || deviceQualifier AS field,
        count(*) AS denominator,
        sum(ListLength(glued_uniqs)) AS sum_total_uniqs,
        sum(ListLength(source_uniqs)) AS sum_limited_uniqs,
        sum($filter(glued_uniqs, 'y')) AS sum_yandexuid_count,
        sum($filter(glued_uniqs, 'duid')) AS sum_duid_count,
        sum($filter(glued_uniqs, 'puid')) AS sum_puid_count,
        sum($filter(glued_uniqs, 'gaid')) AS sum_gaid_count,
        sum($filter(glued_uniqs, 'idfa')) AS sum_idfa_count,
        sum($filter(glued_uniqs, 'oaid')) AS sum_oaid_count,
        sum($filter(glued_uniqs, 'ifv')) AS sum_ifv_count,
        sum($filter(glued_uniqs, 'mm_device_id')) AS sum_mm_device_id_count,
    FROM
        $beh_hit_log
    GROUP BY
        trafficQualifier,
        deviceQualifier;

INSERT INTO @metrics
SELECT
    denominator,
    kind,
    field || '_duid' as field,
    sum_duid_count AS absolute
FROM
    $sample
UNION ALL
SELECT
    sum_gaid_count AS absolute,
    denominator,
    kind,
    field || '_gaid' as field
FROM
    $sample
UNION ALL
SELECT
    sum_idfa_count AS absolute,
    denominator,
    kind,
    field || '_idfa' as field
FROM
    $sample
UNION ALL
SELECT
    sum_ifv_count AS absolute,
    denominator,
    kind,
    field || '_ifv' as field
FROM
    $sample
UNION ALL
SELECT
    sum_mm_device_id_count AS absolute,
    denominator,
    kind,
    field || '_mm-device-id' as field
FROM
    $sample
UNION ALL
SELECT
    sum_oaid_count AS absolute,
    denominator,
    kind,
    field || '_oaid' as field
FROM
    $sample
UNION ALL
SELECT
    sum_puid_count AS absolute,
    denominator,
    kind,
    field || '_puid' as field
FROM
    $sample
UNION ALL
SELECT
    sum_total_uniqs AS absolute,
    denominator,
    kind,
    field || '_total-uniqs' as field
FROM
    $sample
UNION ALL
SELECT
    sum_yandexuid_count AS absolute,
    denominator AS denominator,
    kind,
    field || '_yandexuid' as field,
FROM
    $sample
UNION ALL
SELECT
    sum_limited_uniqs AS absolute,
    denominator,
    kind,
    field || '_limited-uniqs' as field
FROM
    $sample
;