$log =
SELECT
    hitlogid,
    IF(uniqid != 0, uniqid, NULL) AS uniqid,
    IF(cryptaidv2 != 0, CAST(cryptaidv2 AS String), NULL) AS crypta_id,
    IF(cryptaid != 0, cryptaid, NULL) AS crypta_id_v1,
    IF(idfa != '', idfa, NULL) AS idfa,
    IF(ifv != '', ifv, NULL) AS ifv,
    IF(gaid != '', gaid, NULL) AS gaid,
    IF(oaid != '', oaid, NULL) AS oaid,
    IF(deviceid != '', deviceid, NULL) AS deviceid,
    IF(indeviceidfa != '', indeviceidfa, NULL) AS indeviceidfa,
    IF(indeviceifv != '', indeviceifv, NULL) AS indeviceifv,
    IF(indevicegaid != '', indevicegaid, NULL) AS indevicegaid,
    IF(indeviceoaid != '', indeviceoaid, NULL) AS indeviceoaid,
    IF(passportuid != 0, passportuid, NULL) AS passportuid,

    String::AsciiToLower(detaileddevicetype) as detaileddevicetype,
    `options_flat-page` as is_rsya,
    `impressionoptions_in-app` as in_app,
    CASE
        WHEN `impressionoptions_is-ssp` THEN 'ssp'
        WHEN `impressionoptions_yandex-page` THEN 'internal'
        ELSE 'external'
    END as rsya_type,

    eventcost AS cost,
FROM $bs_chevent_cooked_log
WHERE placeid IN (542u, 1542u) -- ads from Direct
      AND selecttype NOT IN (0u, 5u, 17u)
      AND fraudbits = 0u -- antifroud
      AND countertype == 1 -- shows
      AND $experiment_by_box(yandexexpboxes) IN ("{{ version }}", "{{ version }}-ext")
;
