{% include '/templates/yql/experiment.sql.j2' %}

{% include '/templates/yql/ads/chevent.sql.j2' %}
-- ========================================================================= --

$stats =
SELECT
    AsStruct(
        count(*) AS events,
        sum(cost) AS cost,
        count_if(crypta_id IS NOT NULL) AS has_crypta_id,
        count_if(crypta_id_v1 IS NOT NULL) AS has_crypta_id_v1,
        count_if(idfa IS NOT NULL) AS has_idfa,
        count_if(ifv IS NOT NULL) AS has_ifv,
        count_if(gaid IS NOT NULL) AS has_gaid,
        count_if(((indevicegaid ?? gaid) IS NOT NULL) AND ((indeviceidfa ?? idfa) IS NOT NULL)) AS has_gaid_and_idfa,
        count_if(((indevicegaid ?? gaid) IS NOT NULL) AND ((indeviceifv ?? ifv) IS NOT NULL)) AS has_gaid_and_ifv,
        count_if(oaid IS NOT NULL) AS has_oaid,
        count_if(passportuid IS NOT NULL) AS has_passportuid,
    )
FROM $log;

$ios_detailed_stats =
SELECT
    'ios_' || IF(in_app, 'inapp', 'web') || '_' || rsya_type AS field,
    count_if(idfa IS NOT NULL) AS has_request_idfa,
    count_if(ifv IS NOT NULL) AS has_request_ifv,
    count_if(deviceid is NOT NULL) AS has_request_mm_device_id,
    count_if(idfa IS NOT NULL OR indeviceidfa IS NOT NULL) AS has_indevice_idfa,
    count_if(ifv IS NOT NULL OR indeviceifv IS NOT NULL) AS has_indevice_ifv,
    count(*) AS total
FROM $log
WHERE is_rsya and detaileddevicetype = 'ios'
AND NOT (rsya_type = 'ssp' AND NOT in_app) -- not intersted in web ssp for now
GROUP BY in_app, rsya_type;

$android_detailed_stats =
SELECT
    'android_' || IF(in_app, 'inapp', 'web') || '_' || rsya_type AS field,
    count_if(gaid IS NOT NULL) AS has_request_gaid,
    count_if(oaid IS NOT NULL) AS has_request_oaid,
    count_if(gaid IS NOT NULL OR oaid IS NOT NULL) AS has_request_gaid_or_oaid,
    count_if(deviceid is NOT NULL) AS has_request_mm_device_id,
    count_if(gaid IS NOT NULL OR indevicegaid IS NOT NULL) AS has_indevice_gaid,
    count_if(oaid IS NOT NULL OR indeviceoaid IS NOT NULL) AS has_indevice_oaid,
    count_if(gaid IS NOT NULL OR indevicegaid IS NOT NULL OR oaid IS NOT NULL OR indeviceoaid  IS NOT NULL) AS has_indevice_gaid_or_oaid,
    count(*) AS total
FROM $log
WHERE is_rsya AND detaileddevicetype = 'android'
AND NOT (rsya_type = 'ssp' AND NOT in_app) -- not intersted in web ssp for now
GROUP BY in_app, rsya_type;

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    CAST(absolute AS Double) AS absolute,
    CAST(denominator AS Double) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $stats.has_crypta_id AS absolute,
        $stats.events AS denominator,
        'chevent_cryptaid' AS field
    UNION ALL SELECT
        $stats.has_crypta_id_v1 AS absolute,
        $stats.events AS denominator,
        'chevent_cryptaid_v1' AS field
    UNION ALL SELECT
        $stats.has_passportuid AS absolute,
        $stats.events AS denominator,
        'chevent_puid' AS field
    UNION ALL SELECT
        $stats.has_idfa AS absolute,
        $stats.events AS denominator,
        'chevent_idfa' AS field
    UNION ALL SELECT
        $stats.has_ifv AS absolute,
        $stats.events AS denominator,
        'chevent_ifv' AS field
    UNION ALL SELECT
        $stats.has_gaid AS absolute,
        $stats.events AS denominator,
        'chevent_gaid' AS field
    UNION ALL SELECT
        $stats.has_oaid AS absolute,
        $stats.events AS denominator,
        'chevent_oaid' AS field
    UNION ALL SELECT
        $stats.has_gaid_and_idfa AS absolute,
        $stats.events AS denominator,
        'gaid_idfa_conflict' AS field
    UNION ALL SELECT
        $stats.has_gaid_and_ifv AS absolute,
        $stats.events AS denominator,
        'gaid_ifv_conflict' AS field

    UNION ALL SELECT
        field || '_has_request_idfa' as field,
        has_request_idfa AS absolute,
        total AS denominator
    FROM $ios_detailed_stats
    UNION ALL SELECT
        field || '_has_request_ifv' as field,
        has_request_ifv AS absolute,
        total AS denominator
    FROM $ios_detailed_stats
    UNION ALL SELECT
        field || '_has_request_mm_device_id' as field,
        has_request_mm_device_id AS absolute,
        total AS denominator
    FROM $ios_detailed_stats
    UNION ALL SELECT
        field || '_has_indevice_idfa' as field,
        has_indevice_idfa AS absolute,
        total AS denominator
    FROM $ios_detailed_stats
    UNION ALL SELECT
        field || '_has_indevice_ifv' as field,
        has_indevice_ifv AS absolute,
        total AS denominator
    FROM $ios_detailed_stats

    UNION ALL SELECT
        field || '_has_request_gaid_or_oaid' as field,
        has_request_gaid_or_oaid AS absolute,
        total AS denominator
    FROM $android_detailed_stats
    UNION ALL SELECT
        field || '_has_indevice_gaid_or_oaid' as field,
        has_indevice_gaid_or_oaid AS absolute,
        total AS denominator
    FROM $android_detailed_stats
    UNION ALL SELECT
        field || '_has_request_mm_device_id' as field,
        has_request_mm_device_id AS absolute,
        total AS denominator
    FROM $android_detailed_stats
);
