{% include '/templates/yql/experiment.sql.j2' %}

{% include '/templates/yql/ads/chevent.sql.j2' %}
-- ========================================================================= --

$id_cryptaid =
SELECT
    CAST(id AS Uint64) AS id,
    cryptaId AS crypta_id,
FROM $crypta_source_data
WHERE id_type IN ('yandexuid', 'xuniq_guid', 'icookie');

$puid_cryptaid =
SELECT
    CAST(id AS Uint64) AS id,
    cryptaId AS crypta_id,
FROM $crypta_source_data
WHERE id_type == 'puid';

$idfa_cryptaid =
SELECT
    id,
    cryptaId AS crypta_id,
FROM $crypta_source_data
WHERE id_type == 'idfa';

$ifv_cryptaid =
SELECT
    id,
    cryptaId AS crypta_id,
FROM $crypta_source_data
WHERE id_type == 'ifv';

$gaid_cryptaid =
SELECT
    id,
    cryptaId AS crypta_id,
FROM $crypta_source_data
WHERE id_type == 'gaid';

$oaid_cryptaid =
SELECT
    id,
    cryptaId AS crypta_id,
FROM $crypta_source_data
WHERE id_type == 'oaid';

$log_uniqid_matching =
SELECT
    hitlogid,
    offline.crypta_id AS crypta_id
FROM $log AS log
JOIN ANY $id_cryptaid AS offline
ON (log.uniqid == offline.id)
WHERE log.uniqid IS NOT NULL;

$log_idfa_matching =
SELECT
    hitlogid,
    offline.crypta_id AS crypta_id,
FROM $log AS log
JOIN ANY $idfa_cryptaid AS offline
ON (log.idfa == offline.id)
WHERE log.idfa IS NOT NULL;

$log_ifv_matching =
SELECT
    hitlogid,
    offline.crypta_id AS crypta_id,
FROM $log AS log
JOIN ANY $ifv_cryptaid AS offline
ON (log.ifv == offline.id)
WHERE log.ifv IS NOT NULL;

$log_gaid_matching =
SELECT
    hitlogid,
    offline.crypta_id AS crypta_id,
FROM $log AS log
JOIN ANY $gaid_cryptaid AS offline
ON (log.gaid == offline.id)
WHERE log.gaid IS NOT NULL;

$log_oaid_matching =
SELECT
    hitlogid,
    offline.crypta_id AS crypta_id,
FROM $log AS log
JOIN ANY $oaid_cryptaid AS offline
ON (log.oaid == offline.id)
WHERE log.oaid IS NOT NULL;

$log_puid_matching =
SELECT
    hitlogid,
    offline.crypta_id AS crypta_id,
FROM $log AS log
JOIN ANY $puid_cryptaid AS offline
ON (log.passportuid == offline.id)
WHERE log.passportuid IS NOT NULL;

$log_matching =
SELECT
    log.hitlogid AS hitlogid,
    log.cost AS cost,
    log.crypta_id AS log_crypta_id,
    log.idfa AS log_idfa,
    log.ifv AS log_ifv,
    log.gaid AS log_gaid,
    log.oaid AS log_oaid,
    log.passportuid AS log_passportuid,
    offline_uniqid.crypta_id AS offline_uniqid_crypta_id,
    offline_idfa.crypta_id AS offline_idfa_crypta_id,
    offline_ifv.crypta_id AS offline_ifv_crypta_id,
    offline_gaid.crypta_id AS offline_gaid_crypta_id,
    offline_oaid.crypta_id AS offline_oaid_crypta_id,
    offline_puid.crypta_id AS offline_puid_crypta_id,
FROM $log AS log
LEFT JOIN ANY $log_uniqid_matching AS offline_uniqid
ON (log.hitlogid == offline_uniqid.hitlogid)
LEFT JOIN ANY $log_idfa_matching AS offline_idfa
ON (log.hitlogid == offline_idfa.hitlogid)
LEFT JOIN ANY $log_ifv_matching AS offline_ifv
ON (log.hitlogid == offline_ifv.hitlogid)
LEFT JOIN ANY $log_gaid_matching AS offline_gaid
ON (log.hitlogid == offline_gaid.hitlogid)
LEFT JOIN ANY $log_oaid_matching AS offline_oaid
ON (log.hitlogid == offline_oaid.hitlogid)
LEFT JOIN ANY $log_puid_matching AS offline_puid
ON (log.hitlogid == offline_puid.hitlogid);

$stats =
SELECT
    AsStruct(
        count(*) AS events,
        sum(cost) AS cost,
        count_if(online_cid IS NOT NULL) AS has_online_crypta_id,
        count_if(offline_cid IS NOT NULL) AS has_offline_crypta_id,
        count_if((online_cid ?? offline_cid) IS NOT NULL) AS has_any_crypta_id,
        count_if((online_cid IS NOT NULL AND offline_cid IS NOT NULL) AND (online_cid != offline_cid)) AS has_diff_crypta_id,
        count_if((online_cid IS NOT NULL AND offline_cid IS NOT NULL) AND (online_cid == offline_cid)) AS has_same_crypta_id
    )
FROM (
    SELECT (offline_puid_crypta_id
                ?? offline_uniqid_crypta_id
                ?? offline_idfa_crypta_id
                ?? offline_ifv_crypta_id
                ?? offline_gaid_crypta_id
                ?? offline_oaid_crypta_id) AS offline_cid,
           log_crypta_id AS online_cid,
           cost AS cost
    FROM $log_matching
);
-- ========================================================================= --

INSERT INTO @metrics
SELECT
    CAST(absolute AS Double) AS absolute,
    CAST(denominator AS Double) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $stats.has_online_crypta_id AS absolute,
        $stats.events AS denominator,
        'chevent_current_coverage' AS field
    UNION ALL SELECT
        $stats.has_offline_crypta_id AS absolute,
        $stats.events AS denominator,
        'chevent_offline_coverage' AS field
    UNION ALL SELECT
        $stats.has_any_crypta_id AS absolute,
        $stats.events AS denominator,
        'chevent_max_coverage' AS field
    UNION ALL SELECT
        $stats.has_diff_crypta_id AS absolute,
        $stats.events AS denominator,
        'chevent_different_online_and_offline_cryptaId' AS field
    UNION ALL SELECT
        $stats.has_same_crypta_id AS absolute,
        $stats.events AS denominator,
        'chevent_same_online_and_offline_cryptaId' AS field
);
