{% include '/templates/yql/experiment.sql.j2' %}

$CostD = ($base, $exp) -> {
    RETURN AsStruct(
        1.0 * ($exp - $base) AS absolute,
        $base AS denominator
    );
};

$WithMatchingExperiments = (
    SELECT
        $experiment_by_box(yandexexpboxes) AS exp,
        CAST(eventcost AS Float) AS Cost,
        placeid AS PlaceID,
        oaid != "" or gaid != "" or idfa != "" or ifv != "" or coalesce(devicetype in (1, 2, 3, 4), false) AS IsMobile
    FROM $bs_chevent_cooked_log
    WHERE
        placeid IN (542u, 1542u)
        AND selecttype NOT IN (0u, 5u, 17u)
        AND fraudbits = 0u
        AND eventcost > 0
        AND $experiment_by_box(yandexexpboxes) IN ("v0", "{{ version }}")
);

$ExperimentEventsPerBin = (
    SELECT
        CASE
            WHEN exp == "{{ version }}" THEN 1
            WHEN exp == "v0" THEN 0
            ELSE NULL
        END AS Bin,
        Cost,
        IsMobile,
        PlaceID
    FROM $WithMatchingExperiments
);

$Costs = (
    SELECT
        Bin,
        IsMobile,
        PlaceID,
        SUM(Cost) AS Cost
    FROM
        $ExperimentEventsPerBin
    GROUP BY
        (Bin, IsMobile, PlaceID)
);

$TotalBase = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 0);
$TotalExp = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 1);
$WebBase = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 0 AND NOT IsMobile);
$WebExp = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 1 AND NOT IsMobile);
$AppBase = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 0 AND IsMobile);
$AppExp = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 1 AND IsMobile);
$ClickBase = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 0 AND PlaceID = 542u);
$ClickExp = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 1 AND PlaceID = 542u);
$ReachBase = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 0 AND PlaceID = 1542u);
$ReachExp = (SELECT SUM(Cost) FROM $Costs WHERE Bin = 1 AND PlaceID = 1542u);


-- ========================================================================= --

INSERT INTO @metrics
SELECT
    CAST(value.absolute AS Double) AS absolute,
    CAST(value.denominator AS Double) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $CostD($TotalBase, $TotalExp) AS value,
        'rsya_total_cost_d' AS field
    UNION ALL SELECT
        $CostD($WebBase, $WebExp) AS value,
        'rsya_web_cost_d' AS field
    UNION ALL SELECT
        $CostD($AppBase, $AppExp) AS value,
        'rsya_app_cost_d' AS field
    UNION ALL SELECT
        $CostD($ClickBase, $ClickExp) AS value,
        'rsya_click_cost_d' AS field
    UNION ALL SELECT
        $CostD($ReachBase, $ReachExp) AS value,
        'rsya_reach_cost_d' AS field
);
