{% include '/templates/yql/experiment.sql.j2' %}

$beh_profile_hit_log = '//logs/beh-profile-hit-log/1h/{{ date }}T11:00:00';
$sample_percent = {% if crypta_env == 'fake' %} 100.0 {% else %} 10.0 {% endif %}; -- by default 10%, for tests 100%

$parsed = (
    SELECT
        ListLength(ListFilter(
            Bigb::ParseProfile(ProfileDump).source_uniqs,
            -- id_type for crypta_id: https://a.yandex-team.ru/arc/trunk/arcadia/yabs/proto/user_profile.proto?rev=6874393#L602
            ($id) -> {return $id.id_type == 4;}
        )) as crypta_ids_count
    FROM $beh_profile_hit_log
    TABLESAMPLE SYSTEM($sample_percent)
    WHERE $experiment_by_udf(`UniqID`, `TimeStamp`) IN ("{{ version }}", "{{ version }}-ext")
    {% if crypta_env == 'fake' %} OR True{% endif %}
);

INSERT INTO @metrics
SELECT
    CAST(count_if(crypta_ids_count > 1) AS Double) AS absolute,
    CAST(count(*) AS Double) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_duplicated_crypta_ids_bigb' AS field
from $parsed;
