{% include '/templates/yql/experiment.sql.j2' %}

$WithMatchingExperiments = (
    SELECT
        $experiment_by_box(yandexexpboxes) AS exp,
        CAST(eventcost AS Float) AS Cost
    FROM $bs_chevent_cooked_log
    WHERE
        placeid IN (542u, 1542u)
        AND selecttype NOT IN (0u, 5u, 17u)
        AND fraudbits = 0u
        AND eventcost > 0
        AND $experiment_by_box(yandexexpboxes) IN ("v0", "{{ version }}")
);

$ExperimentEventsPerBin = (
    SELECT
        CASE
            WHEN exp == "{{ version }}" THEN 1
            WHEN exp == "v0" THEN 0
            ELSE NULL
        END AS Bin,
        Cost
    FROM $WithMatchingExperiments
);

$Costs = (
    SELECT
        Bin,
        SUM(Cost) AS Cost
    FROM $ExperimentEventsPerBin
    GROUP BY Bin
);

$Differences = (
    SELECT
        Bin,
        Cost,
        1.0 * (Cost - LAG(Cost) OVER w) AS absolute,
        (LAG(Cost) OVER w) AS denominator
    FROM $Costs
    WINDOW w AS ()
);

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    absolute,
    denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        CAST(absolute AS Double) AS absolute,
        CAST(denominator AS Double) AS denominator,
        'rsya_cost_d' AS field
    FROM $Differences
    WHERE Bin == 1
);
