{% include '/templates/yql/ads/qualifiers_identification.sql.j2' %}


$beh_hit_log =
    SELECT
        $make_trafficQualifier(Options, SSPID, ImpressionOptions) AS trafficQualifier,
        $make_deviceQualifier(DetailedDeviceType, ImpressionOptions) AS deviceQualifier,
        ListLength(Bigb::ParseProfile(ProfileDump).source_uniqs) AS source_uniqs,
        ListLength(Bigb::ParseProfile(ProfileDump).glued_uniqs) AS glued_uniqs
    FROM
        `//home/bs/logs/JoinedEFHProfileHitLog/Shows/1h/{{ date }}T13:00:00`
    WHERE
        FraudBits = 0;

INSERT INTO @metrics
SELECT
    '{{ prefix }}_x_overlimit_' || trafficQualifier || '_' || deviceQualifier AS field,
    '{{ prefix }}' AS kind,
    COUNT_IF(glued_uniqs > source_uniqs) AS absolute,
    COUNT(1) AS denominator,
FROM
    $beh_hit_log
GROUP BY
    trafficQualifier,
    deviceQualifier;