$antispam = (
    SELECT *
    FROM $LAST_TABLE('//home/antispam/export/crypta/DailyCalls')
);

$data_phone = (
    SELECT Identifiers::HashMd5Phone(id) AS id, cryptaId
    FROM $crypta_source_data
    WHERE id_type == "phone"
);

$data_mmdeviceid = (
    SELECT Identifiers::NormalizeMmDeviceId(id) AS id, cryptaId
    FROM $crypta_source_data
    WHERE id_type == "mm_device_id"
);

$phone_devid = (
    SELECT DISTINCT phone, devid
    FROM (
        SELECT
            Identifiers::HashMd5Phone(PhoneNumber) AS phone,
            Identifiers::NormalizeMmDeviceId(DeviceID) AS devid
        FROM $antispam
        WHERE Identifiers::IsValidPhone(PhoneNumber)
            AND Identifiers::IsValidMmDeviceId(DeviceID)
    )
);

$phone_devid_with_cryptaids = (
    SELECT
        t1.phone AS phone,
        t1.devid AS devid,
        t2.cryptaId AS phone_cryptaid,
        t3.cryptaId AS devid_cryptaid
    FROM $phone_devid AS t1
    LEFT JOIN $data_phone AS t2 ON t1.phone == t2.id
    LEFT JOIN $data_mmdeviceid AS t3 ON t1.devid == t3.id
);

$all_count = (
    SELECT count(1)
    FROM $phone_devid
);

$intersect_count = (
    SELECT count(1)
    FROM $phone_devid_with_cryptaids
    WHERE phone_cryptaid == devid_cryptaid
);


-- ========================================================================= --

INSERT INTO @metrics
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $all_count AS absolute,
        'total_matched' AS field
    UNION ALL SELECT
        $intersect_count AS absolute,
        'intersect_count' AS field
    UNION ALL SELECT
        $intersect_count AS absolute,
        $all_count AS denominator,
        'intersect_percent' AS field
);
