$mm_device_id_uuid = $soup_dir || 'mm_device_id_uuid_app-metrica_mm';
$gaid_mm_device_id = $soup_dir || 'gaid_mm_device_id_app-metrica_mm';
$idfa_mm_device_id = $soup_dir || 'idfa_mm_device_id_app-metrica_mm';

$almost_none_share = 0.01;

$apps =
SELECT
    uuid30.id as id,
    uuid30.os as os,
    IF(uuid30.app_id like '%yandex%', '_yandex_apps', '_other_apps') as app_type,
    uuid30.app_id as app_id,
    uuid30.ua_profile as ua_profile,
    uuid30.google_adv_id is not null as has_gaid_30,
    gaid.id1 is not null as has_gaid_soup,
    uuid30.idfa is not null as has_idfa_30,
    idfa.id1 is not null as has_idfa_soup
FROM $uuid_info_month as uuid30
inner join any $mm_device_id_uuid as soup
on uuid30.id = soup.id2
left join any $gaid_mm_device_id as gaid
on soup.id1 = gaid.id2
left join any $idfa_mm_device_id as idfa
on soup.id1 = idfa.id2
where uuid30.os in ('android', 'ios');

$strange_devices =
select
    ua_profile
from $apps
group by ua_profile
-- filter devices that are not supposed to report idfa/gaid by their nature
having avg(has_gaid_soup or has_idfa_soup) < $almost_none_share;

$android_stats =
select
    os,
    app_type,
    count_if(has_gaid_30) as has_gaid_30,
    count_if(has_gaid_soup) as has_gaid_soup,
    count(*) as total
from $apps
where ua_profile not in $strange_devices and os = 'android'
group by os, app_type;

$ios_stats =
select
    os,
    app_type,
    count_if(has_idfa_30) as has_idfa_30,
    count_if(has_idfa_soup) as has_idfa_soup,
    count(*) as total
from $apps
where ua_profile not in $strange_devices and os = 'ios'
group by os, app_type;

INSERT INTO @metrics
SELECT
    CAST(absolute AS Double) AS absolute,
    CAST(denominator AS Double) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || Unwrap(field) AS field
FROM (
SELECT
    has_gaid_30 AS absolute,
    total AS denominator,
    os || app_type || '_has_gaid_30' AS field
FROM $android_stats

UNION ALL SELECT
    has_gaid_soup AS absolute,
    total AS denominator,
    os || app_type || '_has_gaid_soup' AS field
FROM $android_stats

UNION ALL SELECT
    has_idfa_30 AS absolute,
    total AS denominator,
    os || app_type || '_has_idfa_30' AS field
FROM $ios_stats

UNION ALL SELECT
    has_idfa_soup AS absolute,
    total AS denominator,
    os || app_type || '_has_idfa_soup' AS field
FROM $ios_stats
);