$avito_pageids = (
    '106253', -- Name=avito.ru
    '125616', -- Name=m.avito.ru
    '125618', -- Name=m.avito.ru
    '134783', -- Name=com.avito.android
    '134784', -- Name=ru.avito.app
    '145619', -- Name=avito.iOS
    '161308', -- Name=avito.ru
    '188382', -- Name=avito.ru
    '189903', -- Name=avito.ru
    '192620', -- Name=com.avito.android
    '192629', -- Name=ru.avito.app
    '207376', -- Name=com.avito.android
    '208411', -- Name=m.avito.ru
    '217153', -- Name=ru.avito.app
    '228614', -- Name=m.avito.ru
    '273712', -- Name=avito.ru
    '279179', -- Name=avito.ru
    '280196'  -- Name=avito.ru
);

$avito_vals_mapped = (
    select uniqid, `uuid`, nvl(kw726, kw727) as avito_hash from (
        select
            uniqid,
            Url::GetCGIParam('http://fake/?' || queryargs, '245') as `uuid`,
            Url::GetCGIParam('http://fake/?' || queryargs, '726') as kw726,
            Url::GetCGIParam('http://fake/?' || queryargs, '727') as kw727
        from CONCAT(
            `//home/logfeller/logs/bs-hit-log/1d/{{ date }}`,
            `//home/logfeller/logs/bs-rtb-log/1d/{{ date }}`
        )
        where pageid in $avito_pageids
    ) where `uuid` is not null
        or kw726 is not null
        or kw727 is not null
);

$avito_vals = (
    select distinct uniqid, `uuid`, avito_hash
    from $avito_vals_mapped
);

$avito_uuids = (
    select distinct `uuid`
    from $avito_vals
);

$avito_idfas = (
    select distinct(idfa) as idfa from (
        select a.idfa as idfa
        from $uuid_info_month as a
        inner join $avito_uuids as b on a.`uuid` = b.`uuid`
        where a.idfa is not null
    )
);

$avito_ifvs = (
    select distinct(ifv) as ifv from (
        select a.ifv as ifv
        from $uuid_info_month as a
        inner join $avito_uuids as b on a.`uuid` = b.`uuid`
        where a.idfa is null
            AND a.ifv is not null
    )
);

$avito_gaids = (
    select distinct(gaid) as gaid from (
        select a.google_adv_id as gaid
        from $uuid_info_month as a
        inner join $avito_uuids as b on a.`uuid` = b.`uuid`
        where a.google_adv_id is not null
    )
);

$avito_oaids = (
    SELECT DISTINCT(oaid) AS oaid FROM (
        SELECT a.open_id AS oaid
        FROM $uuid_info_month AS a
        INNER JOIN $avito_uuids AS b ON a.`uuid` = b.`uuid`
        WHERE a.google_adv_id IS NULL
            AND a.open_id IS NOT NULL
    )
);

$idfas_with_cid = (
    select a.idfa as idfa, b.cryptaId as cryptaId
    from $avito_idfas as a
    inner join `{{ source }}` as b
    on a.idfa = b.id
    where b.id_type = 'idfa'
);

$ifvs_with_cid = (
    select a.ifv as ifv, b.cryptaId as cryptaId
    from $avito_ifvs as a
    inner join `{{ source }}` as b
    on a.ifv = b.id
    where b.id_type = 'ifv'
);

$gaids_with_cid = (
    select a.gaid as gaid, b.cryptaId as cryptaId
    from $avito_gaids as a
    inner join `{{ source }}` as b
    on a.gaid = b.id
    where b.id_type = 'gaid'
);

$oaids_with_cid = (
    SELECT a.oaid AS oaid, b.cryptaId AS cryptaId
    FROM $avito_oaids AS a
    INNER JOIN `{{ source }}` AS b
    ON a.oaid = b.id
    WHERE b.id_type = 'oaid'
);

$vertices_no_multi_profile_by_crypta_id = '//home/crypta/production/state/graph/{{ version }}/matching/vertices_no_multi_profile_by_crypta_id';
$vertices_properties_by_crypta_id = '//home/crypta/production/state/graph/{{ version }}/matching/vertices_properties_by_crypta_id';

$idfas_with_yuids = (
    select distinct(a.idfa) as idfa from $idfas_with_cid as a
    inner join $vertices_no_multi_profile_by_crypta_id as b
        on a.cryptaId = b.cryptaId
    inner join $vertices_properties_by_crypta_id as c
        on c.id = b.id
    where b.id_type = 'yandexuid' and c.ip_activity_type = 'active'
);

$ifvs_with_yuids = (
    select distinct(a.ifv) as ifv from $ifvs_with_cid as a
    inner join $vertices_no_multi_profile_by_crypta_id as b
        on a.cryptaId = b.cryptaId
    inner join $vertices_properties_by_crypta_id as c
        on c.id = b.id
    where b.id_type = 'yandexuid' and c.ip_activity_type = 'active'
);

$gaids_with_yuids = (
    select distinct(a.gaid) as gaid from $gaids_with_cid as a
    inner join $vertices_no_multi_profile_by_crypta_id as b
        on a.cryptaId = b.cryptaId
    inner join $vertices_properties_by_crypta_id as c
        on c.id = b.id
    where b.id_type = 'yandexuid' and c.ip_activity_type = 'active'
);

$oaids_with_yuids = (
    select distinct(a.oaid) as oaid from $oaids_with_cid as a
    inner join $vertices_no_multi_profile_by_crypta_id as b
        on a.cryptaId = b.cryptaId
    inner join $vertices_properties_by_crypta_id as c
        on c.id = b.id
    where b.id_type = 'yandexuid' and c.ip_activity_type = 'active'
);

$ios_idfa = (select count(*) from $avito_idfas);
$ios_ifv = (select count(*) from $avito_ifvs);
$ios = $ios_idfa + $ios_ifv;

$ios_idfa_with_yuid = (select count(*) from $idfas_with_yuids);
$ios_ifv_with_yuid = (select count(*) from $ifvs_with_yuids);
$ios_with_yuid = $ios_idfa_with_yuid + $ios_ifv_with_yuid;

$android_gaid = (select count(*) from $avito_gaids);
$android_oaid = (select count(*) from $avito_oaids);
$android = $android_gaid + $android_oaid;

$android_with_yuid_gaid = (select count(*) from $gaids_with_yuids);
$android_with_yuid_oaid = (select count(*) from $oaids_with_yuids);
$android_with_yuid = $android_with_yuid_gaid + $android_with_yuid_oaid;

$yuids_with_avito = (
    select count(distinct(uniqid)) from $avito_vals
    where
        avito_hash is not null and
        uniqid is not null and
        uniqid != '0' and
        `uuid` is null
);

$uuids_with_avito = (
    select count(distinct `uuid`) from $avito_vals
    where avito_hash is not null
        and `uuid` is not null
);

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $ios_with_yuid AS absolute,
        $ios AS denominator,
        'ios_with_yuid' AS field
    UNION ALL SELECT
        $android_with_yuid AS absolute,
        $android AS denominator,
        'android_with_yuid' AS field
    UNION ALL SELECT
        $ios_with_yuid + $android_with_yuid AS absolute,
        $ios + $android AS denominator,
        'total_with_yuid' AS field
    UNION ALL SELECT
        $uuids_with_avito AS absolute,
        'uuids_with_avito' AS field
    UNION ALL SELECT
        $yuids_with_avito AS absolute,
        'yuids_with_avito' AS field
);
