$yandexbrowser = 'yandexbrowser';

$top_desktop_browsers = AsSet(
    'chrome',
    $yandexbrowser,
    'firefox',
    'msie',
    'opera',
    'edge',
    'safari',
    'headlesschrome',
    'chromium',
    'coccoc',
);

-- ========================================================================= --

$yandexuid_cryptaid =
SELECT
    id_type,
    id,
    cryptaId,
FROM $crypta_source_data
WHERE id_type == 'yandexuid';

$yuid_info =
SELECT
    id,
    id_type,
    IF(DictContains($top_desktop_browsers, browser), browser, 'other') AS browser
FROM $yuid_with_all_info
WHERE
    browser IS NOT NULL
    AND String::StartsWith(ua_profile, 'd')
    AND ip_activity_type == 'active';

$yuid_info_with_crypta_id =
SELECT
    ids_info.id AS id,
    browser,
    cryptaId
FROM $yuid_info AS ids_info
LEFT JOIN ANY $yandexuid_cryptaid AS yc
USING (id, id_type);

-- collect crypta ids info
$crypta_id_info_grouping =
SELECT
    cryptaId,
    browser,
    COUNT(*) AS number
FROM $yuid_info_with_crypta_id
WHERE cryptaId IS NOT NULL
GROUP BY cryptaId, browser;

$crypta_id_info =
SELECT
    cryptaId,
    ToDict(AGGREGATE_LIST(AsTuple(browser, number))) AS stat
FROM $crypta_id_info_grouping
GROUP BY cryptaId;

$yuid_info_with_crypta_id_info =
SELECT
    browser,
    ids_info.cryptaId IS NOT NULL AS has_crypta_id,
    IF(
        browser != $yandexbrowser,
        DictContains(c_info.stat, $yandexbrowser),
        DictLookup(c_info.stat, $yandexbrowser) > 1
    ) AS has_yet_yandex_browser,
    IF(browser == $yandexbrowser, DictContains(c_info.stat, 'chrome'), false) AS has_chrome_browser,
    IF(browser == $yandexbrowser, DictLookup(c_info.stat, $yandexbrowser) > 1, false) AS has_yandex_browser,
    IF(browser == $yandexbrowser, DictContains(c_info.stat, 'firefox'), false) AS has_firefox_browser,
    IF(browser == $yandexbrowser, DictContains(c_info.stat, 'msie'), false) AS has_msie_browser,
    IF(browser == $yandexbrowser, DictContains(c_info.stat, 'opera'), false) AS has_opera_browser,
    IF(browser == $yandexbrowser, DictContains(c_info.stat, 'edge'), false) AS has_edge_browser,
    IF(browser == $yandexbrowser, DictContains(c_info.stat, 'safari'), false) AS has_safari_browser,
    IF(browser == $yandexbrowser, DictContains(c_info.stat, 'headlesschrome'), false) AS has_headlesschrome_browser,
    IF(browser == $yandexbrowser, DictContains(c_info.stat, 'chromium'), false) AS has_chromium_browser,
    IF(browser == $yandexbrowser, DictContains(c_info.stat, 'coccoc'), false) AS has_coccoc_browser
FROM $yuid_info_with_crypta_id AS ids_info
LEFT JOIN ANY $crypta_id_info AS c_info
USING (cryptaId);

-- aggregate by browser
$browsers_stats =
SELECT
    browser,
    COUNT(*) AS yandexuids_count,
    COUNT_IF(has_crypta_id) AS has_crypta_id,
    COUNT_IF(has_yet_yandex_browser) AS has_yet_yandex_browser,
    AsStruct(
        COUNT_IF(has_chrome_browser) AS has_chrome_browser,
        COUNT_IF(has_yandex_browser) AS has_yandex_browser,
        COUNT_IF(has_firefox_browser) AS has_firefox_browser,
        COUNT_IF(has_msie_browser) AS has_msie_browser,
        COUNT_IF(has_opera_browser) AS has_opera_browser,
        COUNT_IF(has_edge_browser) AS has_edge_browser,
        COUNT_IF(has_safari_browser) AS has_safari_browser,
        COUNT_IF(has_headlesschrome_browser) AS has_headlesschrome_browser,
        COUNT_IF(has_chromium_browser) AS has_chromium_browser,
        COUNT_IF(has_coccoc_browser) AS has_coccoc_browser,
    ) AS yabro_stat
FROM $yuid_info_with_crypta_id_info
GROUP BY browser;

-- aggregate by yandex browser
$yabro_total = SELECT COUNT(*) FROM $yuid_info WHERE browser == $yandexbrowser;

$yabro_stat =
SELECT
    yabro_stat
FROM $browsers_stats
WHERE browser == $yandexbrowser;

-- ========================================================================= --

$aggregate_by_browser =
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        browser || '_has_crypta_id' AS field,
        has_crypta_id AS absolute,
        yandexuids_count AS denominator
    FROM $browsers_stats
    UNION ALL SELECT
        browser || '_has_yandexbrowser' AS field,
        has_yet_yandex_browser AS absolute,
        yandexuids_count AS denominator
    FROM $browsers_stats
);

$aggregate_by_yandex_browser =
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_yandexbrowser_has_' || field AS field
FROM (
    SELECT
        'chrome' AS field,
        $yabro_stat.has_chrome_browser AS absolute,
        $yabro_total AS denominator
    UNION ALL SELECT
        'yandexbrowser' AS field,
        $yabro_stat.has_yandex_browser AS absolute,
        $yabro_total AS denominator
    UNION ALL SELECT
        'firefox' AS field,
        $yabro_stat.has_firefox_browser AS absolute,
        $yabro_total AS denominator
    UNION ALL SELECT
        'msie' AS field,
        $yabro_stat.has_msie_browser AS absolute,
        $yabro_total AS denominator
    UNION ALL SELECT
        'opera' AS field,
        $yabro_stat.has_opera_browser AS absolute,
        $yabro_total AS denominator
    UNION ALL SELECT
        'edge' AS field,
        $yabro_stat.has_edge_browser AS absolute,
        $yabro_total AS denominator
    UNION ALL SELECT
        'safari' AS field,
        $yabro_stat.has_safari_browser AS absolute,
        $yabro_total AS denominator
    UNION ALL SELECT
        'headlesschrome' AS field,
        $yabro_stat.has_headlesschrome_browser AS absolute,
        $yabro_total AS denominator
    UNION ALL SELECT
        'chromium' AS field,
        $yabro_stat.has_chromium_browser AS absolute,
        $yabro_total AS denominator
    UNION ALL SELECT
        'coccoc' AS field,
        $yabro_stat.has_coccoc_browser AS absolute,
        $yabro_total AS denominator
);

INSERT INTO @metrics
SELECT
    COALESCE(absolute, 0) as absolute,
    COALESCE(denominator, 0) as denominator,
    UNWRAP(kind) as kind,
    UNWRAP(field) as field
FROM (
    SELECT * FROM $aggregate_by_browser
    UNION ALL
    SELECT * FROM $aggregate_by_yandex_browser
);
