{% if select_query != 'for_dashboard' %}PRAGMA yt.InferSchema;{% endif %}

$rough_mobile_ua_profile = Re2::Capture(@@m\|[a-z]+\|[a-z]+\|[a-z]+\|[0-9]+@@);

{% if select_query == 'for_dashboard' %}
{# use abs template import path #}
{% include '/templates/yql/device_id_in_crypta_id/vertices_%s.sql.j2' % version %}
{% else %}
{% include 'vertices_%s.sql' % version %}
{% endif %}

-- fetch yandexuid in crypta id features
$active_yandexuids = (
    select
        id,
        CASE
            WHEN ua_profile like "m|%" THEN "mobile"
            WHEN ua_profile like "d|desk%" THEN "desktop"
            ELSE "other"
        END as device_type,
        $rough_mobile_ua_profile(ua_profile)._0 as rough_ua_profile,
        ip_activity_type
    from $yuid_with_all_info
);

$active_yandexuids_with_crypta_id = (
    select
        yuids.id as yandexuid,
        yuids.device_type as device_type,
        yuids.ip_activity_type as ip_activity_type,
        yuids.rough_ua_profile as rough_ua_profile,
        matching.cryptaId as cryptaId
    from $active_yandexuids as yuids
    INNER JOIN $filtered_matching as matching
    using (id)
);

$crypta_id_activity_by_yandexuid = (
    select
        cryptaId,

        True as has_any_yandexuid,
        IF(COUNT_IF(device_type = 'mobile') > 0,
            True, False) as has_any_mobile_yandexuid,
        IF(COUNT_IF(device_type = 'desktop') > 0,
            True, False) as has_any_desktop_yandexuid,

        IF(COUNT_IF(ip_activity_type = 'active') > 0,
            True, False) as has_active_any_yandexuid,
        IF(COUNT_IF(device_type = 'mobile' and ip_activity_type = 'active') > 0,
            True, False) as has_active_mobile_yandexuid,
        IF(COUNT_IF(device_type = 'desktop' and ip_activity_type = 'active') > 0,
            True, False) as has_active_desktop_yandexuid,

        AGGREGATE_LIST(rough_ua_profile) as mobile_ua_profiles
    from $active_yandexuids_with_crypta_id
    group by cryptaId
);

-- fetch daily devices
$daily_device_ids = (
    select
        id,
        id_type,
        CASE
            WHEN os = 'ios' THEN 'ios'
            WHEN os = 'android' THEN 'android'
            ELSE "other"
        END as os,
        IF(main_region_country == 225, "russia", "not_russia") as is_russia,
        $rough_mobile_ua_profile(ua_profile)._0 as rough_ua_profile
    from `//home/crypta/production/state/graph/{{ date }}/mobile/dev_info_yt`
);

$daily_device_ids_with_crypta_id = (
    select
        devices.id as id,
        devices.id_type as id_type,
        devices.os as os,
        devices.is_russia as is_russia,
        devices.rough_ua_profile as rough_ua_profile,
        matching.cryptaId as cryptaId
    from $daily_device_ids as devices
    left join $filtered_matching as matching
    using (id)
);

--- match daily devices and crypta id yandexuid features
$daily_device_ids_with_active_yandexuid_crypta_id = (
    select
        devices.id as id,
        devices.id_type as id_type,
        devices.os as os,
        devices.is_russia as is_russia,
        target_crypta_ids.cryptaId as cryptaId,

        target_crypta_ids.has_any_yandexuid as has_any_yandexuid,
        target_crypta_ids.has_any_mobile_yandexuid as has_any_mobile_yandexuid,
        target_crypta_ids.has_any_desktop_yandexuid as has_any_desktop_yandexuid,

        target_crypta_ids.has_active_any_yandexuid as has_active_any_yandexuid,
        target_crypta_ids.has_active_mobile_yandexuid as has_active_mobile_yandexuid,
        target_crypta_ids.has_active_desktop_yandexuid as has_active_desktop_yandexuid,
        (
            ListHas(
                Unwrap(target_crypta_ids.mobile_ua_profiles ?? ListCreate(String)),
                Unwrap(devices.rough_ua_profile ?? '')
            )
            and
            target_crypta_ids.has_active_mobile_yandexuid
        ) as has_ua_match_mobile_yandexuid
    from $daily_device_ids_with_crypta_id as devices
    left join $crypta_id_activity_by_yandexuid as target_crypta_ids
    using (cryptaId)
);

-- calculate aggregations
{% if select_query == 'for_dashboard' %}
    {% include '/templates/yql/device_id_in_crypta_id/select_for_dashboard.sql.j2' %}
{% else %}
    {% include 'select_%s.sql' % select_query %}
{% endif %}
