$aggerate_counts_and_percents = (
    '{{ date }}' AS fielddate,
    COUNT_IF(has_any_yandexuid == True) AS has_any_yandexuid_count,
    COUNT_IF(has_active_any_yandexuid == True) AS has_active_any_yandexuid_count,
    COUNT_IF(has_active_mobile_yandexuid == True) AS has_active_mobile_yandexuid_count,
    COUNT_IF(has_active_desktop_yandexuid == True) AS has_active_desktop_yandexuid_count,
    COUNT_IF(has_ua_match_mobile_yandexuid == True) AS has_ua_match_mobile_yandexuid_count,

    COUNT(id) AS devices_daily_count,

    CAST(COUNT_IF(has_any_yandexuid == True) AS Double)
        / COUNT(id) AS has_any_yandexuid_percent,
    CAST(COUNT_IF(has_active_any_yandexuid == True) AS Double)
        / COUNT(id) AS has_active_any_yandexuid_percent,
    CAST(COUNT_IF(has_active_mobile_yandexuid == True) AS Double)
        / COUNT(id) AS has_active_mobile_yandexuid_percent,
    CAST(COUNT_IF(has_active_desktop_yandexuid == True) AS Double)
        / COUNT(id) AS has_active_desktop_yandexuid_percent,
    CAST(COUNT_IF(has_ua_match_mobile_yandexuid == True) AS Double)
        / COUNT(id) AS has_ua_match_mobile_yandexuid_percent
);

SELECT * FROM (
    SELECT
        AsStruct(
            os AS os,
            is_russia AS is_russia
        ),
        $aggerate_counts_and_percents
    FROM $daily_device_ids_with_active_yandexuid_crypta_id
    GROUP BY os, is_russia

UNION ALL

    SELECT
        AsStruct(
            'all' AS os,
            is_russia AS is_russia
        ),
        $aggerate_counts_and_percents
    FROM $daily_device_ids_with_active_yandexuid_crypta_id
    GROUP BY is_russia

UNION ALL

    SELECT
        AsStruct(
            os AS os,
            'all' AS is_russia
        ),
        $aggerate_counts_and_percents
    FROM $daily_device_ids_with_active_yandexuid_crypta_id
    GROUP BY os

UNION ALL

    SELECT
        AsStruct(
            'all' AS os,
            'all' AS is_russia
        ),
        $aggerate_counts_and_percents
    FROM $daily_device_ids_with_active_yandexuid_crypta_id
) FLATTEN COLUMNS;
