DEFINE SUBQUERY $yandexuid_slices($filter_os) AS
    SELECT
        AsStruct(
            count(id) AS total,
            count_if(has_any_yandexuid) AS has_any_yandexuid,
            count_if(has_any_mobile_yandexuid) AS has_any_mobile_yandexuid,
            count_if(has_any_desktop_yandexuid) AS has_any_desktop_yandexuid,
            count_if(has_active_any_yandexuid) AS has_active_any_yandexuid,
            count_if(has_active_mobile_yandexuid) AS has_active_mobile_yandexuid,
            count_if(has_active_desktop_yandexuid) AS has_active_desktop_yandexuid,
        )
    FROM $daily_device_ids_with_active_yandexuid_crypta_id
    WHERE is_russia == 'russia' AND $filter_os(os, id_type);
END DEFINE;

$ios_with_idfa = SELECT * FROM $yandexuid_slices(($os, $id_type) -> ($os == 'ios' AND $id_type == 'idfa'));
$ios_without_idfa = SELECT * FROM $yandexuid_slices(($os, $id_type) -> ($os == 'ios' AND $id_type != 'idfa'));

$android_with_gaid = SELECT * FROM $yandexuid_slices(($os, $id_type) -> ($os == 'android' AND $id_type == 'gaid'));
$android_without_gaid = SELECT * FROM $yandexuid_slices(($os, $id_type) -> ($os == 'android' AND $id_type != 'gaid'));

$other = SELECT * FROM $yandexuid_slices(($os, $id_type) -> ($os == 'other'));

$any_os = SELECT * FROM $yandexuid_slices(($os, $id_type) -> (TRUE));

$has_ua_match_mobile_yandexuid_count = (
    SELECT count_if(has_ua_match_mobile_yandexuid == True)
    FROM $daily_device_ids_with_active_yandexuid_crypta_id
    WHERE is_russia == 'russia'
);

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    -- any os
    SELECT
        $any_os.has_any_yandexuid AS absolute,
        'has_any_yandexuid_count' AS field
    UNION ALL SELECT
        $any_os.has_any_mobile_yandexuid AS absolute,
        'has_any_mobile_yandexuid_count' AS field
    UNION ALL SELECT
        $any_os.has_any_desktop_yandexuid AS absolute,
        'has_any_desktop_yandexuid_count' AS field

    UNION ALL SELECT
        $any_os.has_active_any_yandexuid AS absolute,
        'has_active_any_yandexuid_count' AS field
    UNION ALL SELECT
        $any_os.has_active_mobile_yandexuid AS absolute,
        'has_active_mobile_yandexuid_count' AS field
    UNION ALL SELECT
        $any_os.has_active_desktop_yandexuid AS absolute,
        'has_active_desktop_yandexuid_count' AS field

    UNION ALL SELECT
        $has_ua_match_mobile_yandexuid_count AS absolute,
        'has_ua_match_mobile_yandexuid_count' AS field

    UNION ALL SELECT
        $any_os.total AS absolute,
        'devices_daily_count' AS field

    UNION ALL SELECT
        $any_os.has_any_yandexuid AS absolute,
        $any_os.total AS denominator,
        'has_any_yandexuid_percent' AS field
    UNION ALL SELECT
        $any_os.has_any_mobile_yandexuid AS absolute,
        $any_os.total AS denominator,
        'has_any_mobile_yandexuid_percent' AS field
    UNION ALL SELECT
        $any_os.has_any_desktop_yandexuid AS absolute,
        $any_os.total AS denominator,
        'has_any_desktop_yandexuid_percent' AS field

    UNION ALL SELECT
        $any_os.has_active_any_yandexuid AS absolute,
        $any_os.total AS denominator,
        'has_active_any_yandexuid_percent' AS field
    UNION ALL SELECT
        $any_os.has_active_mobile_yandexuid AS absolute,
        $any_os.total AS denominator,
        'has_active_mobile_yandexuid_percent' AS field
    UNION ALL SELECT
        $any_os.has_active_desktop_yandexuid AS absolute,
        $any_os.total AS denominator,
        'has_active_desktop_yandexuid_percent' AS field

    UNION ALL SELECT
        $has_ua_match_mobile_yandexuid_count AS absolute,
        $any_os.total AS denominator,
        'has_ua_match_mobile_yandexuid_percent' AS field

    -- ios with idfa

    UNION ALL SELECT
        $ios_with_idfa.total AS absolute,
        'devices_ios_with_idfa_daily_count' AS field

    UNION ALL SELECT
        $ios_with_idfa.has_any_yandexuid AS absolute,
        $ios_with_idfa.total AS denominator,
        'has_any_yandexuid_ios_with_idfa_percent' AS field
    UNION ALL SELECT
        $ios_with_idfa.has_any_mobile_yandexuid AS absolute,
        $ios_with_idfa.total AS denominator,
        'has_any_mobile_yandexuid_ios_with_idfa_percent' AS field
    UNION ALL SELECT
        $ios_with_idfa.has_any_desktop_yandexuid AS absolute,
        $ios_with_idfa.total AS denominator,
        'has_any_desktop_yandexuid_ios_with_idfa_percent' AS field

    UNION ALL SELECT
        $ios_with_idfa.has_active_any_yandexuid AS absolute,
        $ios_with_idfa.total AS denominator,
        'has_active_any_yandexuid_ios_with_idfa_percent' AS field
    UNION ALL SELECT
        $ios_with_idfa.has_active_mobile_yandexuid AS absolute,
        $ios_with_idfa.total AS denominator,
        'has_active_mobile_yandexuid_ios_with_idfa_percent' AS field
    UNION ALL SELECT
        $ios_with_idfa.has_active_desktop_yandexuid AS absolute,
        $ios_with_idfa.total AS denominator,
        'has_active_desktop_yandexuid_ios_with_idfa_percent' AS field

    -- ios without idfa

    UNION ALL SELECT
        $ios_without_idfa.total AS absolute,
        'devices_ios_without_idfa_daily_count' AS field

    UNION ALL SELECT
        $ios_without_idfa.has_any_yandexuid AS absolute,
        $ios_without_idfa.total AS denominator,
        'has_any_yandexuid_ios_without_idfa_percent' AS field
    UNION ALL SELECT
        $ios_without_idfa.has_any_mobile_yandexuid AS absolute,
        $ios_without_idfa.total AS denominator,
        'has_any_mobile_yandexuid_ios_without_idfa_percent' AS field
    UNION ALL SELECT
        $ios_without_idfa.has_any_desktop_yandexuid AS absolute,
        $ios_without_idfa.total AS denominator,
        'has_any_desktop_yandexuid_ios_without_idfa_percent' AS field

    UNION ALL SELECT
        $ios_without_idfa.has_active_any_yandexuid AS absolute,
        $ios_without_idfa.total AS denominator,
        'has_active_any_yandexuid_ios_without_idfa_percent' AS field
    UNION ALL SELECT
        $ios_without_idfa.has_active_mobile_yandexuid AS absolute,
        $ios_without_idfa.total AS denominator,
        'has_active_mobile_yandexuid_ios_without_idfa_percent' AS field
    UNION ALL SELECT
        $ios_without_idfa.has_active_desktop_yandexuid AS absolute,
        $ios_without_idfa.total AS denominator,
        'has_active_desktop_yandexuid_ios_without_idfa_percent' AS field

    -- android with gaid

    UNION ALL SELECT
        $android_with_gaid.total AS absolute,
        'devices_android_with_gaid_daily_count' AS field

    UNION ALL SELECT
        $android_with_gaid.has_any_yandexuid AS absolute,
        $android_with_gaid.total AS denominator,
        'has_any_yandexuid_android_with_gaid_percent' AS field
    UNION ALL SELECT
        $android_with_gaid.has_any_mobile_yandexuid AS absolute,
        $android_with_gaid.total AS denominator,
        'has_any_mobile_yandexuid_android_with_gaid_percent' AS field
    UNION ALL SELECT
        $android_with_gaid.has_any_desktop_yandexuid AS absolute,
        $android_with_gaid.total AS denominator,
        'has_any_desktop_yandexuid_android_with_gaid_percent' AS field

    UNION ALL SELECT
        $android_with_gaid.has_active_any_yandexuid AS absolute,
        $android_with_gaid.total AS denominator,
        'has_active_any_yandexuid_android_with_gaid_percent' AS field
    UNION ALL SELECT
        $android_with_gaid.has_active_mobile_yandexuid AS absolute,
        $android_with_gaid.total AS denominator,
        'has_active_mobile_yandexuid_android_with_gaid_percent' AS field
    UNION ALL SELECT
        $android_with_gaid.has_active_desktop_yandexuid AS absolute,
        $android_with_gaid.total AS denominator,
        'has_active_desktop_yandexuid_android_with_gaid_percent' AS field

    -- android without gaid

    UNION ALL SELECT
        $android_without_gaid.total AS absolute,
        'devices_android_without_gaid_daily_count' AS field

    UNION ALL SELECT
        $android_without_gaid.has_any_yandexuid AS absolute,
        $android_without_gaid.total AS denominator,
        'has_any_yandexuid_android_without_gaid_percent' AS field
    UNION ALL SELECT
        $android_without_gaid.has_any_mobile_yandexuid AS absolute,
        $android_without_gaid.total AS denominator,
        'has_any_mobile_yandexuid_android_without_gaid_percent' AS field
    UNION ALL SELECT
        $android_without_gaid.has_any_desktop_yandexuid AS absolute,
        $android_without_gaid.total AS denominator,
        'has_any_desktop_yandexuid_android_without_gaid_percent' AS field

    UNION ALL SELECT
        $android_without_gaid.has_active_any_yandexuid AS absolute,
        $android_without_gaid.total AS denominator,
        'has_active_any_yandexuid_android_without_gaid_percent' AS field
    UNION ALL SELECT
        $android_without_gaid.has_active_mobile_yandexuid AS absolute,
        $android_without_gaid.total AS denominator,
        'has_active_mobile_yandexuid_android_without_gaid_percent' AS field
    UNION ALL SELECT
        $android_without_gaid.has_active_desktop_yandexuid AS absolute,
        $android_without_gaid.total AS denominator,
        'has_active_desktop_yandexuid_android_without_gaid_percent' AS field

    -- other

    UNION ALL SELECT
        $other.total AS absolute,
        'devices_other_os_daily_count' AS field

    UNION ALL SELECT
        $other.has_any_yandexuid AS absolute,
        $other.total AS denominator,
        'has_any_yandexuid_other_os_percent' AS field
    UNION ALL SELECT
        $other.has_any_mobile_yandexuid AS absolute,
        $other.total AS denominator,
        'has_any_mobile_yandexuid_other_os_percent' AS field
    UNION ALL SELECT
        $other.has_any_desktop_yandexuid AS absolute,
        $other.total AS denominator,
        'has_any_desktop_yandexuid_other_os_percent' AS field

    UNION ALL SELECT
        $other.has_active_any_yandexuid AS absolute,
        $other.total AS denominator,
        'has_active_any_yandexuid_other_os_percent' AS field
    UNION ALL SELECT
        $other.has_active_mobile_yandexuid AS absolute,
        $other.total AS denominator,
        'has_active_mobile_yandexuid_other_os_percent' AS field
    UNION ALL SELECT
        $other.has_active_desktop_yandexuid AS absolute,
        $other.total AS denominator,
        'has_active_desktop_yandexuid_other_os_percent' AS field
);
