DEFINE SUBQUERY $crypta_id_matching($id_type) AS
    SELECT id, id_type, cryptaId as crypta_id
    FROM $crypta_source_data
    where id_type == $id_type
END DEFINE;

DEFINE SUBQUERY $ru_id_type($id_type) AS
    SELECT id
    FROM $device_id_info_month
    WHERE id_type == $id_type
        AND main_region_country == $ru_region
END DEFINE;

DEFINE SUBQUERY $crypta_id_with_ru_id_type_count($id_type) AS
    SELECT
        COUNT(DISTINCT t1.crypta_id)
    FROM $crypta_id_matching($id_type) AS t1
    LEFT SEMI JOIN $ru_id_type($id_type) AS t2
    USING (id)
END DEFINE;

DEFINE SUBQUERY $indevice_id_with_ru_id_type_count($id_type) AS
    SELECT
        COUNT(DISTINCT t1.indevice_id)
    FROM (
        SELECT id, indevice_id
        FROM $indevice
        WHERE id_type == $id_type
    ) AS t1
    LEFT SEMI JOIN $ru_id_type($id_type) AS t2
    USING (id)
END DEFINE;

-- ========================================================================= --

$ru_idfa_count = SELECT COUNT(1) FROM $ru_id_type('idfa');
$ru_ifv_count = SELECT COUNT(1) FROM $ru_id_type('ifv');
$ru_gaid_count = SELECT COUNT(1) FROM $ru_id_type('gaid');
$ru_oaid_count = SELECT COUNT(1) FROM $ru_id_type('oaid');

$crypta_id_with_ru_idfa_count = SELECT * FROM $crypta_id_with_ru_id_type_count('idfa');
$crypta_id_with_ru_ifv_count = SELECT * FROM $crypta_id_with_ru_id_type_count('ifv');
$crypta_id_with_ru_gaid_count = SELECT * FROM $crypta_id_with_ru_id_type_count('gaid');
$crypta_id_with_ru_oaid_count = SELECT * FROM $crypta_id_with_ru_id_type_count('oaid');

$indevice_id_with_ru_idfa_count = SELECT * FROM $indevice_id_with_ru_id_type_count('idfa');
$indevice_id_with_ru_ifv_count = SELECT * FROM $indevice_id_with_ru_id_type_count('ifv');
$indevice_id_with_ru_gaid_count = SELECT * FROM $indevice_id_with_ru_id_type_count('gaid');
$indevice_id_with_ru_oaid_count = SELECT * FROM $indevice_id_with_ru_id_type_count('oaid');

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $crypta_id_with_ru_idfa_count AS absolute,
        $ru_idfa_count AS denominator,
        'ru_idfa_crypta_id_percent' AS field
    UNION ALL SELECT
        $indevice_id_with_ru_idfa_count AS absolute,
        $ru_idfa_count AS denominator,
        'ru_idfa_indevice_id_percent' AS field
    UNION ALL SELECT
        $crypta_id_with_ru_ifv_count AS absolute,
        $ru_ifv_count AS denominator,
        'ru_ifv_crypta_id_percent' AS field
    UNION ALL SELECT
        $indevice_id_with_ru_ifv_count AS absolute,
        $ru_ifv_count AS denominator,
        'ru_ifv_indevice_id_percent' AS field
    UNION ALL SELECT
        $crypta_id_with_ru_gaid_count AS absolute,
        $ru_gaid_count AS denominator,
        'ru_gaid_crypta_id_percent' AS field
    UNION ALL SELECT
        $indevice_id_with_ru_gaid_count AS absolute,
        $ru_gaid_count AS denominator,
        'ru_gaid_indevice_id_percent' AS field
    UNION ALL SELECT
        $crypta_id_with_ru_oaid_count AS absolute,
        $ru_oaid_count AS denominator,
        'ru_oaid_crypta_id_percent' AS field
    UNION ALL SELECT
        $indevice_id_with_ru_oaid_count AS absolute,
        $ru_oaid_count AS denominator,
        'ru_oaid_indevice_id_percent' AS field
);
