------ Common Functions -------------------------------------------------------
$yandexuid_type = ($ua_profile) -> {
    return String::SplitToList(
        $ua_profile, '|', True AS SkipEmpty
    )[0];
};

$Russia = 225;
$Active = "active";

-- Assume yandexuid has one type only, but ensure duplicates
$ru_active_yandexuids = (
    select yandexuid,
        -- desktop < mobile
        min(yandexuid_type) as yandexuid_type
    from ( select Unwrap(CAST(id AS UInt64)) AS yandexuid,
                -- 41:35 Member not found: yall
                -- $yandexuid_type(yall.ua_profile) as yandexuid_type
                $yandexuid_type(ua_profile) as yandexuid_type
           from $yuid_with_all_info
           where ip_activity_type == $Active
                 and main_region_country == $Russia
         )
    group by yandexuid
);

$ru_active_mobile_yandexuids = (
    select yandexuid
    from $ru_active_yandexuids
    where yandexuid_type == "m"
);

$ru_active_desktop_yandexuids = (
    select yandexuid
    from $ru_active_yandexuids
    where yandexuid_type == "d"
);

------ Calculate Entropy -------------------------------------------------------
$metrika_hits = (
    select cast(uniqid as uint64) as yandexuid
    from $bs_watch_log
    where uniqid != "0"
);

$hit_cids = (
    select matching.crypta_id_size as crypta_id_size
    from $metrika_hits as metrika_hits
         -- filter active ru yandexuids
         inner join $ru_active_yandexuids as active
             on (active.yandexuid == metrika_hits.yandexuid)
         -- if not joins log2(crypta_id_size) = -inf
         inner join $CRYPTA_RAW() as matching
             on (metrika_hits.yandexuid == matching.yandexuid)
);

$entropy = (
    select avg(Math::Log2(crypta_id_size))
    from $hit_cids
);

------ Calculate Coverage ------------------------------------------------------

$day_yandexuids = (
    select distinct
           yandexuid
    from (
        select cast(uniqid as uint64) as yandexuid
        from $bs_watch_log
        where uniqid != "0"
    )
);

-- Multiple Recalc optimization
--
-- insert into `//home/crypta/team/mittov/wl-yuid-2017-12-25`
-- with truncate (
--     select *
--     from $day_yandexuids
-- );

-- $day_yandexuids = (
--     select yandexuid
--     from `//home/crypta/team/mittov/wl-yuid-2017-12-25`
-- );

$day_ru_active_mobile_yandexuids = (
    select wl.yandexuid as yandexuid
    from $day_yandexuids as wl
         inner join $ru_active_mobile_yandexuids as mobile
             on ( wl.yandexuid = mobile.yandexuid )
);

$has_desktop = (
    select distinct
           matching.crypta_id as crypta_id
    from $CRYPTA_RAW() as matching
         inner join $ru_active_desktop_yandexuids as desktop
             on (desktop.yandexuid == matching.yandexuid)
);

$matched_mobile = (
    select distinct
           mobile.yandexuid as yandexuid,
           matching.crypta_id as crypta_id
    from $CRYPTA_RAW() as matching
         inner join $day_ru_active_mobile_yandexuids as mobile
             on (mobile.yandexuid == matching.yandexuid)
         inner join $has_desktop as has_desktop
             on (matching.crypta_id == has_desktop.crypta_id)
);

$day_ru_active_mobile_count = (
    select count(*)
    from $day_ru_active_mobile_yandexuids
);

$matched_mobile_count = (
    select count(distinct yandexuid)
    from $matched_mobile
);

$coverage = (
    SELECT
        IF(
            $day_ru_active_mobile_count != 0,
            1.0 * $matched_mobile_count / $day_ru_active_mobile_count,
            0  -- skip NaN
        )
);

$entropy_metric = (
    select $coverage / $entropy
);

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $day_ru_active_mobile_count AS absolute,
        'mobile_total_count' AS field
    UNION ALL SELECT
        $matched_mobile_count AS absolute,
        'matched_mobile_count' AS field
    UNION ALL SELECT
        $matched_mobile_count AS absolute,
        $day_ru_active_mobile_count AS denominator,
        'coverage' AS field
    UNION ALL SELECT
        $entropy AS absolute,
        'entropy' AS field
    UNION ALL SELECT
        $coverage AS absolute,
        $entropy AS denominator,
        'entropy_metric' AS field
);
