$observed_exp_ids = ($expids) -> {
    RETURN ToSet(
        ListFilter(
            $expids,
            ($id) -> {
                RETURN $id IN {
                    273124,
                    273122,
                    273123,
                    352607,
                    352608,
                    465406,
                    465407,
                    465408
                }
            }
        )
    );
};

$experiment_case_select = ($expids) -> {
    $exps = $observed_exp_ids($expids);
    RETURN CASE
        WHEN 273124 IN $exps THEN 'v0'
        WHEN 273122 IN $exps THEN 'v2'
        WHEN 273123 IN $exps THEN 'v2exp'
        WHEN 352607 IN $exps THEN 'v2-ext'
        WHEN 352608 IN $exps THEN 'v2exp-ext'
        WHEN 465406 IN $exps THEN 'michurin'
        WHEN 465407 IN $exps THEN 'michurin'
        WHEN 465408 IN $exps THEN 'michurin'
        ELSE 'n/a'
    END;
};

$Experiments = Bigb::LoadExperimentSystemWithAb(FilePath('select_type'), FilePath('ab_experiments_config'), True);

$GetActiveExperiments = ($yandexuid, $timestamp) -> {
    RETURN Bigb::GetActiveExperiments($Experiments, $yandexuid, $timestamp);
};

$experiment_by_box = ($boxes) -> {
    RETURN $experiment_case_select(
        ListMap(
            String::SplitToList($boxes, ";"),
            ($each) -> {
                RETURN CAST(String::SplitToList($each, ",")[0] AS Uint64);
            }
        )
    );
};

$experiment_by_udf = ($yandexuid, $timestamp) -> {
    RETURN $experiment_case_select(
        ListMap(
            $GetActiveExperiments(
                CAST($yandexuid AS Uint64),
                CAST($timestamp AS Uint64)
            ),
            ($each) -> {
                RETURN $each.ExperimentID - 20000000;
            }
        )
    );
};
