$date = '{{ date }}';
$min_active_date = DateTime::Format("%Y-%m-%d")(Date('{{ date }}') - DateTime::IntervalFromDays(30));

$social = ('email', 'login', 'ok_id', 'vk_id', 'vk_name', 'fb_id');
$device = ('idfa', 'ifv', 'gaid', 'oaid', 'distr_r1', 'distr_ui');

$active_yuids_socials_devices = (
    select distinct cryptaId, id, id_type
    from (
        select cryptaId, id1Type as id_type, id1 as id
        from $edges_by_cryptaid
        where ListMax(dates) >= $min_active_date and (id1Type == "yandexuid" or id1Type in $social or id1Type in $device)
        union all
        select cryptaId, id2Type as id_type, id2 as id
        from $edges_by_cryptaid
        where ListMax(dates) >= $min_active_date and (id2Type == "yandexuid" or id2Type in $social or id2Type in $device)
        -- TODO: rm crutch for login-puid, check by soup udf
        UNION ALL
        SELECT cryptaId, id2Type AS id_type, id2 AS id
        FROM $edges_by_cryptaid
        WHERE id1Type == "puid"
            AND id2Type == "login"
            AND sourceType == "passport-profile"
            AND logSource == "passport-dict"
    )
);

$active_yuids = (
    select distinct cryptaId, id
    from $active_yuids_socials_devices
    where id_type == "yandexuid"
);

$active_nonprivate_yuids_from_russia = (
    select t1.cryptaId as cryptaId, t1.id as id, (t2.ua_profile like "d|desk|%") or (t2.ua_profile like "m|%") as is_device
    from $active_yuids as t1 join $yuid_with_all_info as t2 using(id)
    where (t2.main_region_country == 225 or t2.main_region_country is null) and t2.ip_activity_type not in ("private", "one_day")
);

$active_social_or_device = (
    select cryptaId, "social" as id_type
    from (
        select distinct cryptaId
        from $active_yuids_socials_devices
        where id_type in $social
    )
    union all
    select cryptaId, "device" as id_type
    from (
        select distinct cryptaId
        from $active_yuids_socials_devices
        where id_type in $device
    )
);

$devices_from_active_nonprivate_yuids_from_russia = (
    select cryptaId, 'device' as id_type
    from $active_nonprivate_yuids_from_russia
    where is_device
);

$summary = (
    select cryptaId, "yandexuid" as id_type
    from $active_nonprivate_yuids_from_russia
    union all
    select *
    from $active_social_or_device
    union all
    select *
    from $devices_from_active_nonprivate_yuids_from_russia
);

$cryptaid_like_human = (
    select cryptaId, AGGREGATE_LIST_DISTINCT(id_type) as id_types
    from $summary
    group by cryptaId
);

$like_human = (
    select count(distinct cryptaId)
    from $cryptaid_like_human
    where ListHas(id_types, 'yandexuid') and ListHas(id_types, 'device') and ListHas(id_types, 'social')
);

$without_yandexuid = (
    select count(distinct cryptaId)
    from $cryptaid_like_human
    where (not ListHas(id_types, 'yandexuid')) and ListHas(id_types, 'device') and ListHas(id_types, 'social')
);

$without_device = (
    select count(distinct cryptaId)
    from $cryptaid_like_human
    where ListHas(id_types, 'yandexuid') and (not ListHas(id_types, 'device')) and ListHas(id_types, 'social')
);

$without_social = (
    select count(distinct cryptaId)
    from $cryptaid_like_human
    where ListHas(id_types, 'yandexuid') and ListHas(id_types, 'device') and (not ListHas(id_types, 'social'))
);

$only_yandexuid = (
    select count(distinct cryptaId)
    from $cryptaid_like_human
    where ListHas(id_types, 'yandexuid') and (not ListHas(id_types, 'device')) and (not ListHas(id_types, 'social'))
);

$only_device = (
    select count(distinct cryptaId)
    from $cryptaid_like_human
    where (not ListHas(id_types, 'yandexuid')) and ListHas(id_types, 'device') and (not ListHas(id_types, 'social'))
);

$only_social = (
    select count(distinct cryptaId)
    from $cryptaid_like_human
    where (not ListHas(id_types, 'yandexuid')) and (not ListHas(id_types, 'device')) and ListHas(id_types, 'social')
);

$not_like_human = (
    select count(distinct cryptaId)
    from $cryptaid_like_human
    where not(ListHas(id_types, 'yandexuid') and ListHas(id_types, 'device') and ListHas(id_types, 'social'))
);

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    -- we need to all metrics be the same type (so use double)
    CAST(absolute AS Double) AS absolute,
    -- all metrics are just absolut (so set denominator as is)
    CAST(absolute AS Double) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $like_human AS absolute,
        'like_human' AS field
    UNION ALL SELECT
        $not_like_human AS absolute,
        'not_like_human' AS field
    UNION ALL SELECT
        $without_yandexuid AS absolute,
        'withot_yandexuid' AS field
    UNION ALL SELECT
        $without_device AS absolute,
        'without_device' AS field
    UNION ALL SELECT
        $without_social AS absolute,
        'without_social' AS field
    UNION ALL SELECT
        $only_yandexuid AS absolute,
        'only_yandexuid' AS field
    UNION ALL SELECT
        $only_device AS absolute,
        'only_device' AS field
    UNION ALL SELECT
        $only_social AS absolute,
        'only_social' AS field
);
