-- ========================================================================= --

$min_active_date = DateTime::Format("%Y-%m-%d")(Date('{{ date }}') - DateTime::IntervalFromDays(30));

-- ========================================================================= --

$active_yuids =
    SELECT DISTINCT id FROM (
        SELECT
            CASE
                WHEN id1Type == 'yandexuid' THEN id1
                WHEN id2Type == 'yandexuid' THEN id2
                ELSE Null
            END AS id
        FROM $prepared_soup
        WITH COLUMNS Struct<dates: List<String>?>
        WHERE ((id1Type == 'yandexuid') OR (id2Type == 'yandexuid'))
            AND ListMax(dates) > $min_active_date

    )
;

$cryptaid_yuid =
    SELECT
        cryptaId,
        id
    FROM $crypta_source_data
    WHERE id_type == 'yandexuid'
    GROUP BY cryptaId, id
;

$cryptaid_yuid_active =
    SELECT
        ccid.cryptaId AS cryptaId,
        ccid.id AS id
    FROM $cryptaid_yuid AS ccid
    LEFT SEMI JOIN $active_yuids AS active_yuids
    USING (id)
;


DEFINE ACTION $id_type_metics($id_type) AS

    $cryptaid_id_type =
        SELECT
            cryptaId,
            id
        FROM $crypta_source_data
        WHERE id_type == $id_type
        GROUP BY cryptaId, id
    ;

    $yuid_with_id_type =
        SELECT
            DISTINCT yuid
        FROM (
            SELECT
                ccid_yuid.id AS yuid
            FROM $cryptaid_yuid AS ccid_yuid
            LEFT SEMI JOIN $cryptaid_id_type AS ccid_id_type
            USING (cryptaId)
        )
    ;

    $yuid_with_id_type_active =
        SELECT
            ccid_yuid.yuid AS yuid
        FROM $yuid_with_id_type AS ccid_yuid
        LEFT SEMI JOIN $active_yuids AS active_yuids
        ON (active_yuids.id == ccid_yuid.yuid)
    ;

    $id_type_uniq =
        SELECT id
        FROM $cryptaid_id_type
        GROUP BY id
    ;

    $id_type_uniq_cryptaid =
        SELECT cryptaId
        FROM $cryptaid_id_type
        GROUP BY cryptaId
    ;

    $id_type_uniq_daily =
        SELECT DISTINCT id FROM (
            SELECT
                CASE
                    WHEN id1Type == $id_type THEN id1
                    WHEN id2Type == $id_type THEN id2
                    ELSE Null
                END AS id
            FROM $prepared_soup
            WITH COLUMNS Struct<dates: List<String>?>
            WHERE ((id1Type == $id_type) OR (id2Type == $id_type))
                AND ListHas(dates, '{{ date }}')
        )
    ;

    $id_type_uniq_with_cookies =
        SELECT id
        FROM $cryptaid_id_type AS ccid_id_type
        LEFT SEMI JOIN $cryptaid_yuid AS ccid_yuid
        USING (cryptaId)
        GROUP BY ccid_id_type.id AS id
    ;

    $id_type_uniq_with_cookies_daily =
        SELECT id
        FROM $id_type_uniq_daily AS id_uniq_daily
        LEFT SEMI JOIN $id_type_uniq_with_cookies AS id_with_cookies
        USING (id)
        GROUP BY id_uniq_daily.id AS id
    ;

    $id_type_uniq_with_cookies_active =
        SELECT id
        FROM $cryptaid_id_type AS ccid_id_type
        LEFT SEMI JOIN $cryptaid_yuid_active AS ccid_yuid
        USING (cryptaId)
        GROUP BY ccid_id_type.id AS id
    ;

    $id_type_counted_ids =
        SELECT COUNT(id) as count_ids
        FROM $cryptaid_id_type
        GROUP BY cryptaId
    ;

    -- ========================================================================= --

    $total_cryptaid_yuids = (
        SELECT COUNT(DISTINCT id) FROM $cryptaid_yuid);
    $total_cryptaid_active_yuids = (
        SELECT COUNT(DISTINCT id) FROM $cryptaid_yuid_active);
        
    $yuid_with_id_type_count = (
        SELECT COUNT(1) FROM $yuid_with_id_type);
    $yuid_with_id_type_active_count = (
        SELECT COUNT(1) FROM $yuid_with_id_type_active);


    $id_type_uniq_count = (
        SELECT COUNT(1) FROM $id_type_uniq);
    $id_type_uniq_cryptaid_count = (
        SELECT COUNT(1) FROM $id_type_uniq_cryptaid);
    $id_type_uniq_daily_count = (
        SELECT COUNT(1) FROM $id_type_uniq_daily);
    $id_type_uniq_with_cookies_count = (
        SELECT COUNT(1) FROM $id_type_uniq_with_cookies);
    $id_type_uniq_with_cookies_daily_count = (
        SELECT COUNT(1) FROM $id_type_uniq_with_cookies_daily);
    $id_type_uniq_with_cookies_active_count = (
        SELECT COUNT(1) FROM $id_type_uniq_with_cookies_active);
    $id_type_uniq_gt_1 = (
      SELECT COUNT(1) FROM $id_type_counted_ids WHERE count_ids > 1);
    $id_type_uniq_gt_5 = (
      SELECT COUNT(1) FROM $id_type_counted_ids WHERE count_ids > 5);

    -- ========================================================================= --

    INSERT INTO @metrics
    SELECT
        absolute,
        IF(denominator IS NULL, absolute, denominator) AS denominator,
        '{{ prefix }}' AS kind,
        '{{ prefix }}_x_' || field AS field
    FROM (
        SELECT
            $yuid_with_id_type_count AS absolute,
            $total_cryptaid_yuids AS denominator,
            $id_type || '_with_yuids_coverage' AS field
        UNION ALL SELECT
            $yuid_with_id_type_active_count AS absolute,
            $total_cryptaid_active_yuids AS denominator,
            $id_type || '_with_active_yuids_coverage' AS field

        UNION ALL SELECT
            $id_type_uniq_count AS absolute,
            $id_type || '_uniq' AS field
        UNION ALL SELECT
            $id_type_uniq_cryptaid_count AS absolute,
            $id_type || '_uniq_cryptaid' AS field
        UNION ALL SELECT
            $id_type_uniq_daily_count AS absolute,
            $id_type || '_uniq_daily' AS field
        UNION ALL SELECT
            $id_type_uniq_with_cookies_count AS absolute,
            $id_type || '_uniq_with_cookies' AS field
        UNION ALL SELECT
            $id_type_uniq_with_cookies_active_count AS absolute,
            $id_type || '_uniq_with_active_cookies' AS field
        UNION ALL SELECT
            $id_type_uniq_with_cookies_daily_count AS absolute,
            $id_type || '_uniq_with_cookies_daily' AS field

        UNION ALL SELECT
            $id_type_uniq_gt_1 AS absolute,
            $id_type_uniq_cryptaid_count AS denominator,
            $id_type || '_uniq_gt_1_ratio' AS field
        UNION ALL SELECT
            $id_type_uniq_gt_5 AS absolute,
            $id_type_uniq_cryptaid_count AS denominator,
            $id_type || '_uniq_gt_5_ratio' AS field
    );

END DEFINE;

DO $id_type_metics('puid');
DO $id_type_metics('gaid');
DO $id_type_metics('oaid');
DO $id_type_metics('idfa');
DO $id_type_metics('ifv');
DO $id_type_metics('vk_id');
DO $id_type_metics('ok_id');
DO $id_type_metics('phone_md5');
DO $id_type_metics('email_md5');
DO $id_type_metics('mac');
