USE {% if is_embedded %}YtCluster{% elif is_local %}Plato{% else %}{{ yt_proxy.split('.')[0]|title }}{% endif %};  -- {{ yt_proxy }}
-- TITLE: {{ query_title }} {{ metrica.prefix }}
PRAGMA yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

{% include '/templates/yql/common.sql.j2' %}

-- ========================================================================= --

DEFINE ACTION $evaluate_{{ metrica.prefix }}_{{ loop_index }}($LAST_TABLE) AS
    PRAGMA yt.DefaultCluster = '{% if is_embedded %}ytcluster{% elif is_local %}plato{% else %}{{ yt_proxy.split('.')[0]|lower }}{% endif %}';

    {% if tmp_dir %}PRAGMA yt.TmpFolder = '{{ tmp_dir }}';{% endif %}
    {% if not is_embedded and enable_cloud|default(True) %}
    PRAGMA yt.PoolTrees = 'physical';
    PRAGMA yt.TentativePoolTrees = 'cloud';
    {% endif %}
    {% include '/templates/yql/adaptors/matching_%s.sql.j2' % version %}
    {% if pool %}PRAGMA yt.StaticPool = '{{ pool }}';{% endif %}
    {% if transaction_id or tx %}PRAGMA yt.ExternalTx = '{{ transaction_id or tx }}';{% endif %}
    PRAGMA yt.InferSchema;
    PRAGMA yt.IgnoreWeakSchema;

    {% if crypta_env == 'development' %}
    PRAGMA yt.Auth = "robot-crypta";
    {% endif %}

    {% with prefix = metrica.prefix, select_query = 'for_dashboard' %}
        {% include metrica.query + '.j2' %}
    {% endwith %}
END DEFINE;

-- ========================================================================= --
EXPORT $evaluate_{{ metrica.prefix }}_{{ loop_index }};
