$family_data = '//home/msdata/user-profiles/v1/{{ date }}';

-- ========================================================================= --

$family = (
    SELECT
        order_id AS parentOrderId,
        puid AS id
    FROM $family_data
    WHERE state == 'active' AND plan IN {'child', 'parent'}
    GROUP BY order_id, puid
);

$crypta_puids = SELECT
        cryptaId,
        id
    FROM $crypta_source_data
    WHERE id_type == 'puid';

$joined = SELECT
        f.parentOrderId AS parentOrderId,
        f.id AS id,
        p.cryptaId AS cryptaId
    FROM $family AS f
    JOIN $crypta_puids AS p
    USING (id);

-- ========================================================================= --

$cryptaid_stat = SELECT
    AsStruct(
        COUNT(1) AS all,
        COUNT_IF(ids > 1) AS bad
    ) FROM (SELECT
        COUNT(DISTINCT id) AS ids
        FROM $joined
        GROUP BY cryptaId
    );

$family_puids = SELECT CAST(COUNT(DISTINCT id) AS DOUBLE) FROM $family;

-- ========================================================================= --

$script = @@
import itertools

def get_pairwise_stat(puids, k=2):
    number = 0
    bad = 0
    for pair in itertools.combinations(puids, k):
        number += 1
        if pair[0] == pair[1]:
            bad += 1
    return {"number": number, "bad": bad}
@@;

$get_pairwise_stat = Python2::get_pairwise_stat(
    Callable<(List<String>?)->Struct<
        number:Uint32,
        bad:Uint32
    >>,
    $script
);

$family_overgluing = SELECT
        AsStruct(
            SUM(bad) AS bad,
            SUM(number) AS all
        )
    FROM (
        SELECT
            $get_pairwise_stat(AGGREGATE_LIST(cryptaId)).number AS number,
            $get_pairwise_stat(AGGREGATE_LIST(cryptaId)).bad AS bad
        FROM $joined
        GROUP BY parentOrderId
    );

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    CAST(absolute AS Double) AS absolute,
    CAST(denominator AS Double) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $cryptaid_stat.bad AS absolute,
        $cryptaid_stat.all AS denominator,
        'cryptaids_overgluing' AS field
    UNION ALL SELECT
        $family_puids - $cryptaid_stat.all AS absolute,
        $family_puids AS denominator,
        'cryptaid_coverage_of_puid' AS field
    UNION ALL SELECT
        $family_overgluing.bad  AS absolute,
        $family_overgluing.all AS denominator,
        'family_edges_overgluing' AS field
);
