$plus_data = '//home/msdata/user-profiles/v1/{{ date }}';

$plus_puids = (
    SELECT
        DISTINCT puid,
    FROM $plus_data
    WHERE state == 'active' and plus
);

-- ========================================================================= --

$crypta_puids = SELECT
        cryptaId,
        id AS puid
    FROM $crypta_source_data
    WHERE id_type == 'puid';

$joined = SELECT
        p.puid AS puid,
        c.cryptaId AS cryptaId
    FROM $plus_puids AS p
    JOIN $crypta_puids AS c
    USING (puid);

$stat = SELECT
    AsStruct(
        COUNT(1) AS all,
        COUNT_IF(count_puids > 1) AS bad
    ) FROM (SELECT
        COUNT(DISTINCT puid) AS count_puids
        FROM $joined
        GROUP BY cryptaId
    );

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    CAST($stat.bad AS Double) AS absolute,
    CAST($stat.all AS Double) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_cryptaids_overgluing' AS field;
