$get_main_actions = ($items) -> {
    RETURN ListFilter($items, ($item) -> (ListHas($item.link_types, 1)));
}; -- LT_REQUEST = 1 - данный профиль был в запросе


$get_only_crypta_actions = ($items, $link_type) -> { RETURN
    ListFilter($items, ($item) -> (ListHas($item.link_types, $link_type) AND NOT ListHas($item.link_types, 1)))
}; -- $idfy_type = 3 для Vulture, 4 для экспорта, 5 для склейки


$get_statistics = ($rec, $link_type, $debug) -> {
    $only_crypta_actions = $get_only_crypta_actions($rec.actions, $link_type);
    $main_actions = $get_main_actions($rec.actions);

    $only_crypta_action_ids = ListFlatMap($only_crypta_actions, ($i)->(Unwrap($i.ids)));
    $main_action_ids = ListFlatMap($main_actions, ($i)->(Unwrap($i.ids)));

    $result = <|
        hit_id: $rec.hit_id,
        UniqID: $rec.UniqID,
        offers: NULL,
        stats: <|
            duplicates: $rec.duplicates,
            only_crypta_uniqs: ListLength($only_crypta_actions) * $rec.duplicates,
            main_uniqs: ListLength($main_actions) * $rec.duplicates,
            only_crypta_offers: ListLength($only_crypta_action_ids) * $rec.duplicates,
            main_offers: ListLength($main_action_ids) * $rec.duplicates,
            union_only_crypta_offers: ListLength(ListUniq($only_crypta_action_ids)) * $rec.duplicates,
            union_main_offers: ListLength(ListUniq($main_action_ids)) * $rec.duplicates,
        |>
    |>;

    RETURN CASE
        WHEN ListLength($only_crypta_actions) == 0 AND ListLength($main_actions) == 0 THEN NULL
        WHEN $debug AND $rec.hit_id <= 100000 THEN ReplaceMember($result, 'offers', $rec.actions) -- ограничиваем размер дебага 100к строками
        ELSE $result
    END;
};


$get_weighted_avg = ($stats, $field) -> {
    RETURN  1.0 * $stats.$field / $stats.duplicates;
};


DEFINE SUBQUERY $count_metrics($statistics) AS
    $avg = (
        SELECT
            <|
                only_crypta_uniqs: $get_weighted_avg(
                    MULTI_AGGREGATE_BY(stats, AGGREGATION_FACTORY('Sum')),
                    'only_crypta_uniqs'
                ),
                main_uniqs: $get_weighted_avg(
                    MULTI_AGGREGATE_BY(stats, AGGREGATION_FACTORY('Sum')),
                    'main_uniqs'
                ),

                only_crypta_offers: $get_weighted_avg(
                    MULTI_AGGREGATE_BY(stats, AGGREGATION_FACTORY('Sum')),
                    'only_crypta_offers'
                ),
                main_offers: $get_weighted_avg(
                    MULTI_AGGREGATE_BY(stats, AGGREGATION_FACTORY('Sum')),
                    'main_offers'
                ),

                union_only_crypta_offers: $get_weighted_avg(
                    MULTI_AGGREGATE_BY(stats, AGGREGATION_FACTORY('Sum')),
                    'union_only_crypta_offers'
                ),
                union_main_offers: $get_weighted_avg(
                    MULTI_AGGREGATE_BY(stats, AGGREGATION_FACTORY('Sum')),
                    'union_main_offers'
                ),
            |>
        FROM $statistics()
    );

    $metrics = <|
        -- метрики по уникам
        only_crypta_uniqs_avg: <|
            absolute: $avg.only_crypta_uniqs,
        |>,
        main_uniqs_avg: <|
            absolute: $avg.main_uniqs,
        |>,
        uniqs_recall: <|
            absolute: $avg.only_crypta_uniqs,
            denominator: Unwrap($avg.only_crypta_uniqs + $avg.main_uniqs)
        |>,

        -- -- метрики по keyword-события
        only_crypta_offers_avg: <|
            absolute: $avg.only_crypta_offers,
        |>,
        main_offers_avg: <|
            absolute: $avg.main_offers,
        |>,
        offers_recall: <|
            absolute: $avg.only_crypta_offers,
            denominator: Unwrap($avg.only_crypta_offers + $avg.main_offers),
        |>,

        -- -- метрики по уникальным keyword-события
        union_only_crypta_offers_avg: <|
            absolute: $avg.union_only_crypta_offers,
        |>,
        union_main_offers_avg: <|
            absolute: $avg.union_main_offers,
        |>,
        union_offers_recall: <|
            absolute: $avg.union_only_crypta_offers,
            denominator: Unwrap($avg.union_only_crypta_offers + $avg.union_main_offers),
        |>,
    |>;

    -- добавляем колонку denominator
    SELECT StaticMap(
        $metrics,
        ($i) -> {
            RETURN ExpandStruct(
                ForceRemoveMember($i, 'denominator'),
                TryMember($i, 'denominator', 0.0) AS denominator,
            );
        }
    );

END DEFINE;

-- EXPORT $get_statistics, $count_metrics;
