DEFINE SUBQUERY $exported_users() AS
    $last_export = (
        SELECT
            MAX(Path)
        FROM FOLDER($export_dir)
        WHERE Type == "table"
    );

    SELECT
        UniqID,
        user_ids
    FROM (
        SELECT
            ListMap(
                ListFilter(
                    Unwrap(graph).Nodes,
                    ($item) -> ($item.Type == 'yandexuid')
                ),
                ($item) -> (CAST($item.Id AS String))
            ) AS user_ids
        FROM CONCAT($last_export)
    )
    FLATTEN LIST BY user_ids AS UniqID;
END DEFINE;

-- EXPORT $exported_users;
