DEFINE SUBQUERY $crypta_users() AS
    $user_ids = (
        SELECT
            AGGREGATE_LIST(id) AS user_ids,
        FROM (
            SELECT id, cryptaId
            FROM $crypta_source_data
            WHERE id_type == 'yandexuid'
        ) GROUP BY cryptaId
    );

    SELECT
        UniqID,
        user_ids
    FROM $user_ids
    FLATTEN LIST BY user_ids AS UniqID;

END DEFINE;

-- EXPORT $crypta_users;
