$get_actions = ($profile, $keyword) -> {
    RETURN ToMultiDict(
        CASE
            WHEN $keyword == 377
            THEN ListMap(
                Bigb::ParseProfile($profile).offers,
                ($item) -> (AsTuple($item.source_uniq_index, $item.offer_id_md5))
            )
            ELSE ListMap(
                ListFilter(Bigb::ParseProfile($profile).items, ($item) -> ($item.keyword_id == $keyword)),
                ($item) -> (AsTuple($item.source_uniq_index, $item.uint_values[0]))  -- в uint_values по одной цели
            )
        END
    );
};


$needed_link_types = {1, 5, 14}; -- {YANDEX_UID, UNKNOWN_YID, PRIVATE_YANDEX_UID}


$get_sources = ($profile) -> {
    RETURN COALESCE(
        ToDict(
            ListMap(
                ListFilter(
                    ListMap(
                        ListEnumerate(Bigb::ParseProfile($profile).source_uniqs),
                        ($item) -> (AsStruct($item.0 AS index, $item.1 AS uniq))
                    ),
                    ($item) -> ($item.uniq.id_type IN $needed_link_types) -- take only yandexuids
                ),
                ($item) -> { RETURN
                    AsTuple(
                        $item.index,
                        AsStruct(
                            CAST($item.uniq.user_id AS String) AS user_id, -- = UniqID в этом логе, без префикса
                            ListUniq(ListMap($item.uniq.link_types, ($i) -> (IF($i==3, 3, 1)))) AS link_types,
                        )
                        -- link_types has one of:
                        --      LT_UNKNOWN=0
                        --      LT_REQUEST=1 (данный профиль был в запросе)
                        --      LT_CRYPTA_VULTURE=3 (профиль приехал в результате склейки по данным из Vulture)
                        -- (отсюда https://a.yandex-team.ru/arc/trunk/arcadia/yabs/proto/user_profile.proto?rev=6928727#L627-631)
                        --
                        -- далее в оффлайне мы добавим новые виды link_types для offline export = 4 и offline склейки = 5
                        -- на случай, если в будущем эти link_types будут заняты, кастуем здесь всё не 3 к 1
                    );
                }
            ),
        ),
        DictCreate(Uint64, Struct<'user_id': String?, 'is_main': Bool?, 'link_types': List<Uint64>?>)
    )
};


DEFINE SUBQUERY $parse_hit_log($hit_log, $keyword) AS
    -- парсим нужный keyword из часового хит-лога
    -- фильтрую офферы/цели, оставляю пришедшие только из yandexuid
    -- протягиваю к каждому офферу его yandexuid

    $parsed_log = (
        SELECT
            CAST(UniqID AS String?) AS UniqID,
            ListSort(
                ListMap(
                    ListFilter(
                        ListMap(
                            ListZip(
                                ListMap(
                                    DictItems($get_actions(ProfileDump, $keyword)),
                                    ($i) -> (<|source_index: $i.0, ids: $i.1|>)
                                ),
                                ListReplicate($get_sources(ProfileDump), Unwrap(DictLength($get_actions(ProfileDump, $keyword))))
                            ),
                            ($item) -> (<|action_: $item.0, sources: $item.1|>)
                        ),
                        ($item) -> ($item.action_.source_index IN $item.sources)
                    ),
                    ($item) -> (<|
                        user_id: $item.sources[$item.action_.source_index].user_id,
                        link_types: $item.sources[$item.action_.source_index].link_types,
                        ids: ListSort($item.action_.ids)
                    |>)
                ),
                ($item) -> ($item.user_id) -- ключ сортировки
            ) AS actions, -- List< Struct<user_id: String?, link_types: List<Uint64>?, ids: List<Uint64?> >?
        FROM $hit_log()
        WHERE DictHasItems($get_actions(ProfileDump, $keyword))
    );

    $grouped = (
        SELECT
            COUNT(1) AS duplicates,
            UniqID,
            actions,
        FROM $parsed_log
        GROUP COMPACT BY UniqID, actions -- max кол-во ключей единицы тысяч < 1млн поэтому COMPACT
    );

    SELECT
        ROW_NUMBER() OVER w AS hit_id,  -- hit-log не имеет своего id, поэтому генерируем сами
        t.*
    FROM $grouped AS t
    WINDOW w AS ();

END DEFINE;

-- EXPORT $get_actions, $parse_hit_log;
