{% if not (is_embedded or is_local) %}
DEFINE ACTION $DownloadUdf() AS{% autoescape false %}
{%- if True -%}
    {%- if udf_source == 'yt' -%}
        {%- set soup_udf_url = 'yt://hahn/home/crypta/public/udfs/libcrypta_soup_udf.so' -%}
        {%- set identifier_udf_url = 'yt://hahn/home/crypta/public/udfs/libcrypta_identifier_udf.so' -%}
        {%- set rtsklejka_udf_url = 'yt://hahn/home/crypta/public/udfs/libcrypta_rtsklejka_udf.so' -%}
    {%- elif udf_source == 'sandbox' -%}
        {%- set soup_udf_url = 'https://proxy.sandbox.yandex-team.ru/last/CRYPTA_SOUP_UDF?attrs={"released":"stable"}&salt=%s' % time.time() -%}
        {%- set identifier_udf_url = 'https://proxy.sandbox.yandex-team.ru/last/CRYPTA_IDENTIFIERS_UDF?attrs={"released":"stable"}&salt=%s' % time.time() -%}
        {%- set rtsklejka_udf_url = 'https://proxy.sandbox.yandex-team.ru/last/CRYPTA_RTSKLEJKA_UDF?attrs={"released":"stable"}&salt=%s' % time.time() -%}
    {%- endif -%}
        {%- set bigb_udf_url = 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={"released":"stable"}&salt=%s' % time.time() -%}
        {%- set select_type_url = 'https://proxy.sandbox.yandex-team.ru/last/BS_YETI_LIGHT_CONFIGS/select_type_active.json?salt=%s' % time.time() -%}
        {%- set ab_exp_url = 'https://proxy.sandbox.yandex-team.ru/last/BIGB_AB_EXPERIMENTS_PRODUCTION_CONFIG?salt=%s' % time.time() -%}
{%- endif %}
    PRAGMA File('soup_udf.so', {{ "%r" % soup_udf_url }});
    PRAGMA File('libcrypta_identifier_udf.so', {{ "%r" % identifier_udf_url }});
    PRAGMA FILE("rt.udf.so", {{ "%r" % rtsklejka_udf_url }});

    PRAGMA File('select_type', {{ "%r" % select_type_url }});
    PRAGMA File('ab_experiments_config', {{ "%r" % ab_exp_url }});
    PRAGMA File('bigb.so', {{ "%r" % bigb_udf_url }});

    PRAGMA Udf('soup_udf.so');
    PRAGMA Udf('libcrypta_identifier_udf.so');
    PRAGMA Udf('bigb.so');
    PRAGMA Udf('rt.udf.so');
{% endautoescape %}END DEFINE;
DO $DownloadUdf(); COMMIT;
{% endif %}

DEFINE SUBQUERY $LAST_TABLE($dir) AS
    $table_name = Re2::Capture(@@^.*\/(?P<name>[^\/\.]+).*$@@);
    $max_table_name = (
        SELECT MAX($table_name(`Path`).name) AS name
        FROM FOLDER($dir, 'row_count')
        WHERE Type == 'table'
            AND Yson::LookupUint64(Attributes, 'row_count') > 0
    );

    SELECT *
    FROM LIKE($dir, $max_table_name);
END DEFINE;

-- wrap udf to allow use in library action
{% for metrica in metrics %}{% if is_local or is_embedded %}-- {% endif %}PRAGMA Library = "lib_{{ metrica.prefix }}_{{ loop.index }}.sql";
{% endfor %}

{% for metrica in metrics %}IMPORT {% if is_embedded %}.tmp.{% endif %}lib_{{ metrica.prefix }}_{{ loop.index }} SYMBOLS $evaluate_{{ metrica.prefix }}_{{ loop.index }};
{% endfor %}

{% for metrica in metrics %}DO $evaluate_{{ metrica.prefix }}_{{ loop.index }}($LAST_TABLE);
{% endfor %}

COMMIT;

SELECT
    '{{ version }}' AS version,
    DateTime::ToSeconds(DateTime('{{ date }}T12:00:00Z')) AS ts,
    '{{ date }}' AS dt,
    kind,
    field,
    CAST(absolute AS double) AS absolute,
    CAST(denominator AS double) AS denominator,
    IF(denominator != 0, 1.0 * absolute / denominator) AS ratio,
    IF(denominator != 0, 100.0 * absolute / denominator) AS percentage
FROM @metrics
WHERE absolute IS NOT NULL
    AND denominator IS NOT NULL
ORDER BY version, ts, dt, kind, field
INTO RESULT `metrics`;
