
$crypta_ids = (
    SELECT
        cryptaId,
        HyperLogLog(gender) AS gendersCount,
        HyperLogLog(main_region) AS regionsCount,
        HyperLogLog(main_region_country) AS countriesCount,
        HyperLogLog(year_of_birth) AS yearsCount
    FROM $properties
    GROUP BY cryptaId
);

$counts = (
  SELECT
  AsStruct(
      COUNT_IF(gendersCount > 1) AS withMultiGender,
      COUNT_IF(regionsCount > 1) AS withMultiRegion,
      COUNT_IF(countriesCount > 1) AS withMultiCountry,
      COUNT_IF(yearsCount > 1) AS withMultiYear,

      COUNT_IF(gendersCount > 0) AS withGender,
      COUNT_IF(regionsCount > 0) AS withRegion,
      COUNT_IF(countriesCount > 0) AS withCountry,
      COUNT_IF(yearsCount > 0) AS withYear,
      COUNT(*) AS totalCount
  )
  FROM $crypta_ids
);

INSERT INTO @metrics
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $counts.withMultiGender AS absolute,
        $counts.withGender AS denominator,
        'multi_gender' AS field
    UNION ALL SELECT
        $counts.withMultiRegion AS absolute,
        $counts.withRegion AS denominator,
        'multi_region' AS field
    UNION ALL SELECT
        $counts.withMultiCountry AS absolute,
        $counts.withCountry AS denominator,
        'multi_country' AS field
    UNION ALL SELECT
        $counts.withMultiYear AS absolute,
        $counts.withYear AS denominator,
        'multi_year' AS field
    UNION ALL SELECT
        $counts.totalCount AS absolute,
        'properties_count' AS field
);
