-- Common Crypta metrics query template
PRAGMA yt.InferSchema;
PRAGMA yt.IgnoreWeakSchema;
PRAGMA yson.DisableStrict;

{% if crypta_env == 'development' %}
PRAGMA yt.Auth = "robot-crypta";
{% endif %}
-- ========================================================================= --
{% if not is_embedded %}
-- BsyetiUdf
PRAGMA File('select_type', 'https://proxy.sandbox.yandex-team.ru/last/BS_YETI_LIGHT_CONFIGS/select_type_active.json?salt={{ time.time() }}');
PRAGMA File('ab_experiments_config', 'https://proxy.sandbox.yandex-team.ru/last/BIGB_AB_EXPERIMENTS_PRODUCTION_CONFIG?salt={{ time.time() }}');
PRAGMA File('bigb.so', 'https://proxy.sandbox.yandex-team.ru/last/BIGB_UDF?attrs={"released":"stable"}&salt={{ time.time() }}');
PRAGMA Udf('bigb.so');
-- ========================================================================= --
{% endif %}

{% include '/templates/yql/common.sql.j2' %}

{% include '/templates/yql/adaptors/matching_%s.sql.j2' % version %}
-- ========================================================================= --

DEFINE SUBQUERY $LAST_TABLE($dir) AS
    $table_name = Re2::Capture(@@^.*\/(?P<name>[^\/\.]+).*$@@);
    $max_table_name = (
        SELECT MAX($table_name(`Path`).name) AS name
        FROM FOLDER($dir, 'row_count')
        WHERE Type == 'table'
            AND Yson::LookupUint64(Attributes, 'row_count') > 0
    );

    SELECT *
    FROM LIKE($dir, $max_table_name);
END DEFINE;

{% for metrica in metrics %}DEFINE ACTION $evaluate_{{ metrica.prefix }}_{{ loop.index }}($LAST_TABLE, $CRYPTA_RAW) AS
{% with prefix = metrica.prefix, select_query = 'for_dashboard' %}
    {% include metrica.query + '.j2' %}
{% endwith %}
END DEFINE;

{% endfor %}
-- ========================================================================= --

{% for metrica in metrics %}DO $evaluate_{{ metrica.prefix }}_{{ loop.index }}($LAST_TABLE, $CRYPTA_RAW);
{% endfor %}

COMMIT;

SELECT
    '{{ version }}' AS version,
    DateTime::ToSeconds(DateTime('{{ date }}T12:00:00Z')) AS ts,
    '{{ date }}' AS dt,
    kind,
    field,
    CAST(absolute AS double) AS absolute,
    CAST(denominator AS double) AS denominator,
    IF(denominator != 0, 1.0 * absolute / denominator) AS ratio,
    IF(denominator != 0, 100.0 * absolute / denominator) AS percentage
FROM @metrics
WHERE absolute IS NOT NULL
    AND denominator IS NOT NULL
ORDER BY version, ts, dt, kind, field
INTO RESULT `metrics`;
