DEFINE ACTION $make_diff($raw_old, $period) AS
    $new = $crypta_source_data;
    $removed_label = 'removed';
    $new_label = 'new';
    $permanent_label = 'permanent';
    $changed_label = 'changed';

    $joined = (
        SELECT
            old.id_type ?? new.id_type AS id_type,
            CASE
                WHEN old.cryptaId IS NULL THEN $new_label
                WHEN new.cryptaId IS NULL THEN $removed_label
                WHEN old.cryptaId == new.cryptaId THEN $permanent_label
                ELSE $changed_label
            END AS status
        FROM $convert_raw_to_column_format($raw_old) AS old
        FULL JOIN $new AS new USING(id, id_type)
    );

    $accumulated = (
        SELECT
            status,
            CASE GROUPING(
                status,
                id_type
            )
                WHEN 0b01 THEN 'all'
                WHEN 0b00 THEN id_type
                ELSE "other"
            END AS type,
            NVL(COUNT(*), 0) AS absolute
        FROM $joined
        GROUP BY
            GROUPING SETS(
                (status),
                (id_type, status)
            )
    );

    $sum_if_factory = AGGREGATION_FACTORY("SUM_IF");

    $stats = (
        SELECT
            type,
            AsStruct(
                AGGREGATE_BY(AsTuple(absolute, status == $removed_label), $sum_if_factory) AS removed,
                AGGREGATE_BY(AsTuple(absolute, status == $new_label), $sum_if_factory) AS new,
                AGGREGATE_BY(AsTuple(absolute, status == $permanent_label), $sum_if_factory) AS permanent,
                AGGREGATE_BY(AsTuple(absolute, status == $changed_label), $sum_if_factory) AS changed
            ) AS stats
        FROM $accumulated
        GROUP BY (type)
    );

    --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --

    INSERT INTO @metrics
    SELECT
        absolute AS absolute,
        IF(denominator IS NULL, 0, denominator) AS denominator,
        'stable' AS kind,
        NVL('stable_x_' || field || '_' || $period, '') AS field,
    FROM (
        --- <id_type|all>_<new|removed|permanent|changed>_<daily|weekly|monthly>
        SELECT
            type || '_' || status AS field,
            absolute
        FROM $accumulated

        --- <id_type|all>_stability_<daily|weekly|monthly>
        UNION ALL SELECT
            type || '_stability' AS field,
            t.stats.permanent AS absolute,
            NVL(t.stats.permanent, 0) + NVL(t.stats.changed, 0) AS denominator
        FROM $stats AS t

        UNION ALL SELECT
            type || '_stability_removed_upon_prev' AS field,
            t.stats.removed AS absolute,
            NVL(t.stats.removed, 0) + NVL(t.stats.permanent, 0) + NVL(t.stats.changed, 0) AS denominator
        FROM $stats AS t

        UNION ALL SELECT
            type || '_stability_permanent_upon_prev' AS field,
            t.stats.permanent AS absolute,
            NVL(t.stats.removed, 0) + NVL(t.stats.permanent, 0) + NVL(t.stats.changed, 0) AS denominator
        FROM $stats AS t

        UNION ALL SELECT
            type || '_stability_changed_upon_prev' AS field,
            t.stats.changed AS absolute,
            NVL(t.stats.removed, 0) + NVL(t.stats.permanent, 0) + NVL(t.stats.changed, 0) AS denominator
        FROM $stats AS t

        UNION ALL SELECT
            type || '_stability_new_upon_prev' AS field,
            t.stats.new AS absolute,
            NVL(t.stats.removed, 0) + NVL(t.stats.permanent, 0) + NVL(t.stats.changed, 0) AS denominator
        FROM $stats AS t
    );

END DEFINE;
