$EPS = 0.0000001;

$exclude = Pire::Grep("yandex-team|yamoney");
$yson_parse_to_list = ($data, $key) -> {
    RETURN ListFilter(
        Yson::ConvertToStringList(Yson::YPath(Yson::Parse($data), $key)),
        ($id) -> {
            RETURN NOT $exclude($id);
        }
    );
};

$staff_to_join = (
    SELECT id, SOME(staff_login) AS login
    FROM (
        SELECT staff_login, id
        FROM (
            SELECT
                staff_login,
                ListExtend(
                    [passport_login],
                    ListMap($yson_parse_to_list(data, "/phone"), Identifiers::HashMd5Phone),
                    ListMap($yson_parse_to_list(data, "/email"), Identifiers::HashMd5Email)
                ) AS joins
            FROM $staff
        ) FLATTEN LIST BY joins AS id
    ) GROUP BY id
    HAVING COUNT(DISTINCT staff_login) == 1
);

DEFINE SUBQUERY $cryptaid_to_join_subq($id_types) AS
    SELECT id, cryptaId AS cryptaid
    FROM $crypta_source_data
    WHERE id_type IN $id_types
END DEFINE;

$cryptaid_to_join = (SELECT * FROM $cryptaid_to_join_subq({"email_md5", "phone_md5", "login"}));

$id_login_cryptaid = (
    SELECT
        ids.id AS id,
        ids.login AS login,
        cid.cryptaid AS cryptaid
    FROM $staff_to_join AS ids
    INNER JOIN ANY $cryptaid_to_join AS cid
    ON (ids.id == cid.id)
);

$glued_items = (
    SELECT
        cryptaid AS cryptaid,
        AGGREGATE_LIST_DISTINCT(login) AS logins,
        AGGREGATE_LIST(AsTuple(login, id)) AS items
    FROM $id_login_cryptaid
    GROUP BY cryptaid
    HAVING COUNT(DISTINCT login) > 1
);

$glued_logins = (
    SELECT DISTINCT login FROM $glued_items
    FLATTEN LIST BY logins AS login
);

$glued_logins_count = (
    SELECT COUNT(*)
    FROM $glued_logins
);

$av_stats_per_login = (
    SELECT
        AsStruct(
            CAST(SUM(cryptaids_count) AS Double) AS cryptaids_count,
            CAST(SUM(ids_count) AS Double) AS ids_count,
            CAST(COUNT(*) AS Double) + $EPS AS cnt,
            CAST(COUNT_IF(cryptaids_count > 1) AS Double) AS multi_cryptaid_count
        )
    FROM (
        SELECT
            ListLength(AGGREGATE_LIST_DISTINCT(cryptaid)) AS cryptaids_count,
            ListLength(AGGREGATE_LIST_DISTINCT(id)) AS ids_count
        FROM $id_login_cryptaid
        GROUP BY login
    )
);

$av_stats_per_cryptaid = (
    SELECT
        AsStruct(
            CAST(SUM(logins_count) AS Double) AS logins_count,
            CAST(SUM(ids_count) AS Double) AS ids_count,
            CAST(COUNT(*) AS Double) + $EPS AS cnt,
            CAST(COUNT_IF(logins_count > 1) AS Double) AS multi_login_count
        )
    FROM (
        SELECT
            ListLength(AGGREGATE_LIST_DISTINCT(login)) AS logins_count,
            ListLength(AGGREGATE_LIST_DISTINCT(id)) AS ids_count
        FROM $id_login_cryptaid
        GROUP BY cryptaid
    )
);

$not_matched_ids = (
    SELECT
        ids.id AS id,
        ids.login  AS login
    FROM $staff_to_join AS ids
    LEFT ONLY JOIN $cryptaid_to_join AS cid
    ON (ids.id == cid.id)
);

$not_matched_ids_count = (
    SELECT
        CAST(COUNT(DISTINCT id) AS Double)
    FROM $not_matched_ids
);

$matched_ids_count = (
    SELECT CAST(COUNT(DISTINCT id) AS Double)
    FROM $id_login_cryptaid
);

$ids_count = $matched_ids_count + $not_matched_ids_count + $EPS;

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $av_stats_per_login.cryptaids_count AS absolute,
        $av_stats_per_login.cnt AS denominator,
        'av_cryptaids_count_per_login' AS field
    UNION ALL SELECT
        $av_stats_per_login.ids_count AS absolute,
        $av_stats_per_login.cnt AS denominator,
        'av_ids_count_per_login' AS field
    UNION ALL SELECT
        $av_stats_per_login.multi_cryptaid_count AS absolute,
        'login_with_multi_cryptaid_count' AS field
    UNION ALL SELECT
        $av_stats_per_login.multi_cryptaid_count AS absolute,
        $av_stats_per_login.cnt AS denominator,
        'login_with_multi_cryptaid_rate' AS field
    UNION ALL SELECT
        $av_stats_per_login.cnt AS absolute,
        'logins_count' AS field
    UNION ALL SELECT
        $av_stats_per_cryptaid.logins_count AS absolute,
        $av_stats_per_cryptaid.cnt AS denominator,
        'av_logins_count_per_cryptaid' AS field
    UNION ALL SELECT
        $av_stats_per_cryptaid.ids_count AS absolute,
        $av_stats_per_cryptaid.cnt AS denominator,
        'av_ids_count_per_cryptaid' AS field
    UNION ALL SELECT
        $av_stats_per_cryptaid.multi_login_count AS absolute,
        'cryptaid_with_multi_login_count' AS field
    UNION ALL SELECT
        $av_stats_per_cryptaid.multi_login_count AS absolute,
        $av_stats_per_cryptaid.cnt AS denominator,
        'cryptaid_with_multi_login_rate' AS field
    UNION ALL SELECT
        $av_stats_per_cryptaid.cnt AS absolute,
        'cryptaid_count' AS field
    UNION ALL SELECT
        $glued_logins_count AS absolute,
        'glued_logins_count' AS field
    UNION ALL SELECT
        $glued_logins_count AS absolute,
        $av_stats_per_login.cnt AS denominator,
        'glued_logins_ratio' AS field
    UNION ALL SELECT
        $matched_ids_count AS absolute,
        'matched_ids_count' AS field
    UNION ALL SELECT
        $not_matched_ids_count AS absolute,
        'not_matched_ids_count' AS field
    UNION ALL SELECT
        $ids_count AS absolute,
        'total_ids_count' AS field
    UNION ALL SELECT
        $not_matched_ids_count AS absolute,
        $ids_count AS denominator,
        'not_matched_ids_ratio' AS field
);
