-- authorise with robot-crypta
$taxi_data = "//home/taxi-dwh/export/crypta_user_profile/taxi_user_profile/taxi_user_profile";

$data_with_neighbours = (
    SELECT
        passport_uid,
        DictKeys(Yson::ConvertToInt64Dict(Yson::Parse(extra_user_phone_id_stat))) AS neighbour_phones
    FROM $taxi_data
    WHERE ListHasItems(Yson::ConvertToInt64Dict(Yson::Parse(extra_user_phone_id_stat)))
);

$neighbour_phones = (
    SELECT passport_uid, neighbour_phone
    FROM $data_with_neighbours
    FLATTEN LIST BY neighbour_phones AS neighbour_phone
);

$phones = (
    SELECT
        passport_uid, phone
    FROM (
        SELECT passport_uid, Yson::ConvertToStringList(Yson::Parse(user_phone_id_list)) AS phones
        FROM $taxi_data
    )
    FLATTEN LIST BY phones AS phone
);


$as_sorted_tuple = ($id1, $id2) -> {
    $pair = ListSort(AsList($id1, $id2));
    RETURN AsTuple($pair[0], $pair[1]);
};

$pairs = (
    SELECT pair
    FROM (
        SELECT
            $as_sorted_tuple(main.passport_uid, neighbour.passport_uid) AS pair
        FROM $neighbour_phones AS neighbour
        INNER JOIN $phones AS main
        ON (neighbour.neighbour_phone == main.phone)
        WHERE main.passport_uid != neighbour.passport_uid
    )
    GROUP BY pair
);

$puids = (
    SELECT cryptaId, id
    FROM $crypta_source_data
    WHERE id_type == "puid"
);

$pairs_with_crypta_ids = (
    SELECT
        id1.id AS id1,
        id1.cryptaId AS cryptaId1,
        id2.id AS id2,
        id2.cryptaId AS cryptaId2
    FROM $pairs AS pair
        INNER JOIN $puids AS id1
            ON pair.pair.0 == id1.id
        INNER JOIN $puids AS id2
            ON pair.pair.1  == id2.id
);

$glued_pairs = (
    SELECT id1, id2
    FROM $pairs_with_crypta_ids
    WHERE cryptaId1 == cryptaId2
);

$all_count =  (SELECT COUNT(*) FROM $pairs_with_crypta_ids);
$glued_count = (SELECT COUNT(*) FROM $glued_pairs);

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $all_count AS absolute,
        'pairs_count' AS field
    UNION ALL SELECT
        $glued_count AS absolute,
        'glued_pairs_count' AS field
    UNION ALL SELECT
        $glued_count AS absolute,
        $all_count AS denominator,
        'glued_ratio' AS field
);
