$yuids_crypta_id_matching = (
    SELECT id, id_type, cryptaId as crypta_id
    FROM $crypta_source_data
    WHERE id_type = 'yandexuid'
);

$desktops = (
    SELECT id
    FROM $yuid_with_all_info
    WHERE ua_profile LIKE "d|desk|%"
);

$phones = (
    SELECT id
    FROM $yuid_with_all_info
    WHERE ua_profile LIKE "m|phone|%"
);

$tablets = (
    SELECT id
    FROM $yuid_with_all_info
    WHERE ua_profile LIKE "m|tablet|%"
);

$desktops_count = (SELECT COUNT(1) FROM $desktops);
$desktops_in_v2_count = (
    SELECT COUNT(1)
    FROM $desktops AS t1
    LEFT SEMI JOIN $yuids_crypta_id_matching AS t2
    USING (id)
);

$phones_count = (SELECT COUNT(1) FROM $phones);
$phones_in_v2_count = (
    SELECT COUNT(1)
    FROM $phones AS t1
    LEFT SEMI JOIN $yuids_crypta_id_matching AS t2
    USING (id)
);

$tablets_count = (SELECT COUNT(1) FROM $tablets);
$tablets_in_v2_count = (
    SELECT COUNT(1)
    FROM $tablets AS t1
    LEFT SEMI JOIN $yuids_crypta_id_matching AS t2
    USING (id)
);

$ru_yuid = (
    SELECT
        id
    FROM $yuid_with_all_info
    WHERE main_region_country = $ru_region
);

$ru_yuid_count = (SELECT COUNT(1) FROM $ru_yuid);

$crypta_id_with_ru_yuid_count = (
    SELECT
        COUNT(DISTINCT t1.crypta_id)
    FROM $yuids_crypta_id_matching AS t1
    LEFT SEMI JOIN $ru_yuid AS t2
    USING (id)
);

-- ========================================================================= --

INSERT INTO @metrics
SELECT
    absolute,
    IF(denominator IS NULL, absolute, denominator) AS denominator,
    '{{ prefix }}' AS kind,
    '{{ prefix }}_x_' || field AS field
FROM (
    SELECT
        $desktops_in_v2_count AS absolute,
        $desktops_count AS denominator,
        'desktop_percent' AS field
    UNION ALL SELECT
        $phones_in_v2_count AS absolute,
        $phones_count AS denominator,
        'phones_percent' AS field
    UNION ALL SELECT
        $tablets_in_v2_count AS absolute,
        $tablets_count AS denominator,
        'tablets_percent' AS field
    UNION ALL SELECT
        $crypta_id_with_ru_yuid_count AS absolute,
        $ru_yuid_count AS denominator,
        'ru_crypta_id_percent' AS field
);
