import argparse
import datetime
import os

from crypta.graph.metrics.user_params_metrics.lib import UserParamsStatsParser


def make_arg_parser():
    parser = argparse.ArgumentParser(description="Calc user params metrics on YQL")
    parser.add_argument(
        "--approved-domens-table",
        help="YT path to approved domens"
        "Example: //home/crypta/{env}/graph/config/wl_client_user_id/approved_domens",
        required=False,
        default=""
    )
    parser.add_argument(
        "--soup-cooked-edges",
        help="YT path to soup cooked edges"
        "Example: //home/crypta/{env}/state/graph/v2/soup/cooked/soup_edges",
        required=False,
        default=""
    )
    parser.add_argument(
        "--output-dir",
        help="YT path to directory where will be stored metrics"
        "Example: //home/crypta/{env}/graph/metrics/user_params",
        required=False,
        default=""
    )
    parser.add_argument(
        "-d",
        "--date",
        help="Date for metrics calc.",
        required=False,
        default=(datetime.date.today() - datetime.timedelta(days=1)).strftime("%Y-%m-%d")
    )

    return parser


def main():
    args = make_arg_parser().parse_args()

    yt_proxy = os.getenv("YT_PROXY", "hahn.yt.yandex.net")
    yt_pool = os.getenv("YT_POOL", "crypta_graph")

    UserParamsStatsParser(
        args.date, yt_proxy, yt_pool,
        args.soup_cooked_edges,
        args.approved_domens_table,
        args.output_dir
    ).run()


if __name__ == "__main__":
    main()
