{% if not is_embedded %}
PRAGMA Library = 'config.sql';
PRAGMA Library = 'metrica_lib.sql';
{% endif %}

PRAGMA yt.DataSizePerJob = '6G';

PRAGMA yson.DisableStrict;

IMPORT {% if is_embedded %}.lib.{% endif %}config SYMBOLS
    $config
;

IMPORT {% if is_embedded %}.lib.{% endif %}metrica_lib SYMBOLS
    $force_null,
    $ClientUserID,
    $ym_uid_regexp,
    $get_duid,
    $uniqid_was_changed,
    $get_domain,
    $check_phone
;

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
$soup_cooked_edges = '{{ soup_cooked_edges }}';

$date = '{{ date }}';

DEFINE SUBQUERY $get_typed_soup_vertices($idType) AS
    SELECT id2
    FROM (
         SELECT id1 AS id2
         FROM $soup_cooked_edges
         WHERE id1Type == $idType()

         UNION ALL

         SELECT id2
         FROM $soup_cooked_edges
         WHERE id2Type == $idType()
    ) GROUP BY id2;
END DEFINE;

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- for whatch_log (metrika)

{% include 'wl.sql.j2' %}

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- for appmetrica log

{% include 'appmetrica.sql.j2' %}

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --


COMMIT;

SELECT
    *
FROM @metrics
ORDER BY dt, id1Type, id2Type, logSource, sourceType, `domain`
INTO RESULT `metrics`;
